/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.value;

import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.opensourcephysics.ejs.control.value.ParserException;

public final class ParserSuryono {
    private int var_count;
    private String[] var_name;
    private double[] var_value;
    private double[] number;
    private String function = "";
    private String postfix_code = "";
    private boolean valid = false;
    private int error;
    private boolean ISBOOLEAN = false;
    private boolean INRELATION = false;
    private int position;
    private int start;
    private int num;
    private char character;
    private int numberindex;
    private double[] refvalue = null;
    private static final String[] constname = new String[]{"Math.E", "Math.PI"};
    private static final double[] constvalue = new double[]{Math.E, Math.PI};
    private static final String[] funcnameNoParam = new String[]{"Math.random"};
    private static final String[] funcname = new String[]{"Math.abs", "Math.acos", "Math.asin", "Math.atan", "Math.ceil", "Math.cos", "Math.exp", "Math.floor", "Math.log", "Math.rint", "Math.round", "Math.sin", "Math.sqrt", "Math.tan", "Math.toDegrees", "Math.toRadians"};
    private static final String[] extfunc = new String[]{"Math.atan2", "Math.IEEEremainder", "Math.max", "Math.min", "Math.pow"};
    private static final int MAX_NUM = 200;
    private static final int NO_CONST = constname.length;
    private static final int NO_FUNCSNOPARAM = funcnameNoParam.length;
    private static final int NO_FUNCS = funcname.length;
    private static final int NO_EXT_FUNCS = extfunc.length;
    private static final int STACK_SIZE = 50;
    private double[] stack = new double[50];
    private Hashtable references = null;
    private Vector refnames = null;
    public static final int NO_ERROR = 0;
    public static final int SYNTAX_ERROR = 1;
    public static final int PAREN_EXPECTED = 2;
    public static final int UNCOMPILED_FUNCTION = 3;
    public static final int EXPRESSION_EXPECTED = 4;
    public static final int UNKNOWN_IDENTIFIER = 5;
    public static final int OPERATOR_EXPECTED = 6;
    public static final int PAREN_NOT_MATCH = 7;
    public static final int CODE_DAMAGED = 8;
    public static final int STACK_OVERFLOW = 9;
    public static final int TOO_MANY_CONSTS = 10;
    public static final int COMMA_EXPECTED = 11;
    public static final int INVALID_OPERAND = 12;
    public static final int INVALID_OPERATOR = 13;
    public static final int NO_FUNC_DEFINITION = 14;
    public static final int REF_NAME_EXPECTED = 15;
    private static final int FUNC_OFFSET = 1000;
    private static final int EXT_FUNC_OFFSET = 1000 + NO_FUNCS;
    private static final int FUNCNOPARAM_OFFSET = EXT_FUNC_OFFSET + NO_EXT_FUNCS;
    private static final int VAR_OFFSET = 2000;
    private static final int REF_OFFSET = 3000;
    private static final char CONST_OFFSET = '\u00fd';
    private static final char NUMERIC = '\u012c';
    private static final char JUMP_CODE = '\u0001';
    private static final char LESS_THAN = '\u0002';
    private static final char GREATER_THAN = '\u0003';
    private static final char LESS_EQUAL = '\u0004';
    private static final char GREATER_EQUAL = '\u0005';
    private static final char NOT_EQUAL = '\u0006';
    private static final char EQUAL = '\u0007';
    private static final char IF_CODE = '\b';
    private static final char ENDIF = '\t';
    private static final char AND_CODE = '\n';
    private static final char OR_CODE = '\u000b';
    private static final char NOT_CODE = '\f';

    public static boolean isKeyword(String string) {
        try {
            Double.parseDouble(string);
            return true;
        }
        catch (Exception exception) {
            int n;
            for (n = 0; n < NO_CONST; ++n) {
                if (!string.equals(constname[n])) continue;
                return true;
            }
            for (n = 0; n < NO_FUNCS; ++n) {
                if (!string.equals(funcname[n])) continue;
                return true;
            }
            for (n = 0; n < NO_EXT_FUNCS; ++n) {
                if (!string.equals(extfunc[n])) continue;
                return true;
            }
            for (n = 0; n < NO_FUNCSNOPARAM; ++n) {
                if (!string.equals(funcnameNoParam[n])) continue;
                return true;
            }
            return false;
        }
    }

    public static String[] getVariableList(String string) {
        Vector vector = ParserSuryono.getVariableList(string, new Vector());
        if (vector.size() < 1) {
            return new String[0];
        }
        return vector.toArray(new String[1]);
    }

    public static Vector getVariableList(String string, Vector vector) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "() \t+-*/,<>=&|");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (ParserSuryono.isKeyword(string2) || vector.contains(string2)) continue;
            vector.add(string2);
        }
        return vector;
    }

    public ParserSuryono(int n) {
        this.var_count = n;
        this.references = new Hashtable();
        this.refnames = new Vector();
        this.var_name = new String[n];
        this.var_value = new double[n];
        this.number = new double[200];
    }

    public void defineVariable(int n, String string) {
        this.var_name[n] = string;
    }

    public void setVariable(int n, double d) {
        this.var_value[n] = d;
    }

    public void define(String string) {
        this.function = string;
        this.valid = false;
    }

    public void parse() {
        int n;
        String string = new String(this.function);
        String string2 = new String(this.function);
        if (this.valid) {
            return;
        }
        this.num = 0;
        this.error = 0;
        this.references.clear();
        this.refnames.removeAllElements();
        while ((n = string.lastIndexOf(";")) != -1) {
            this.function = string.substring(n + 1) + ')';
            string = string.substring(0, n++);
            String string3 = null;
            int n2 = this.function.indexOf(":");
            if (n2 == -1) {
                this.error = 14;
                this.position = 0;
                while (this.position < this.function.length() && this.function.charAt(this.position) == ' ') {
                    ++this.position;
                }
                ++this.position;
            } else {
                string3 = this.function.substring(0, n2);
                this.function = this.function.substring(n2 + 1);
                if ((string3 = string3.trim()).equals("")) {
                    this.error = 15;
                    this.position = 1;
                } else {
                    n += ++n2;
                    this.parseSubFunction();
                }
            }
            if (this.error != 0) {
                this.position += n;
                break;
            }
            this.references.put(string3, this.postfix_code);
            this.refnames.addElement(string3);
        }
        if (this.error == 0) {
            this.function = string + ')';
            this.parseSubFunction();
        }
        this.function = string2;
        this.valid = this.error == 0;
    }

    public double evaluate() {
        double d;
        int n = this.refnames.size();
        if (!this.valid) {
            this.error = 3;
            return 0.0;
        }
        this.error = 0;
        this.numberindex = 0;
        if (n != 0) {
            String string = this.postfix_code;
            this.refvalue = new double[n];
            for (int i = 0; i < this.refnames.size(); ++i) {
                String string2 = (String)this.refnames.elementAt(i);
                this.postfix_code = (String)this.references.get(string2);
                d = this.evaluateSubFunction();
                if (this.error != 0) {
                    this.postfix_code = string;
                    this.refvalue = null;
                    return d;
                }
                this.refvalue[i] = d;
            }
            this.postfix_code = string;
        }
        d = this.evaluateSubFunction();
        this.refvalue = null;
        if (Double.isNaN(d)) {
            d = 0.0;
        }
        return d;
    }

    public int getErrorCode() {
        return this.error;
    }

    public String getErrorString() {
        return ParserSuryono.toErrorString(this.error);
    }

    public int getErrorPosition() {
        return this.position;
    }

    public static String toErrorString(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = "no error";
                break;
            }
            case 1: {
                string = "syntax error";
                break;
            }
            case 2: {
                string = "parenthesis expected";
                break;
            }
            case 3: {
                string = "uncompiled function";
                break;
            }
            case 4: {
                string = "expression expected";
                break;
            }
            case 5: {
                string = "unknown identifier";
                break;
            }
            case 6: {
                string = "operator expected";
                break;
            }
            case 7: {
                string = "parentheses not match";
                break;
            }
            case 8: {
                string = "internal code damaged";
                break;
            }
            case 9: {
                string = "execution stack overflow";
                break;
            }
            case 10: {
                string = "too many constants";
                break;
            }
            case 11: {
                string = "comma expected";
                break;
            }
            case 12: {
                string = "invalid operand type";
                break;
            }
            case 13: {
                string = "invalid operator";
                break;
            }
            case 14: {
                string = "bad reference definition (: expected)";
                break;
            }
            case 15: {
                string = "reference name expected";
            }
        }
        return string;
    }

    private void skipSpaces() throws ParserException {
        try {
            while (this.function.charAt(this.position - 1) == ' ') {
                ++this.position;
            }
            this.character = this.function.charAt(this.position - 1);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ParserException(7);
        }
    }

    private void getNextCharacter() throws ParserException {
        ++this.position;
        try {
            this.character = this.function.charAt(this.position - 1);
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new ParserException(7);
        }
    }

    private void addCode(char c) {
        this.postfix_code = this.postfix_code + c;
    }

    private void scanNumber() throws ParserException {
        double d;
        String string = "";
        if (this.num == 200) {
            throw new ParserException(10);
        }
        if (this.character != '.') {
            do {
                string = string + this.character;
                this.getNextCharacter();
            } while (this.character >= '0' && this.character <= '9');
        } else {
            string = string + '0';
        }
        if (this.character == '.') {
            do {
                string = string + this.character;
                this.getNextCharacter();
            } while (this.character >= '0' && this.character <= '9');
        }
        if (this.character == 'e' || this.character == 'E') {
            string = string + 'e';
            this.getNextCharacter();
            if (this.character == '+' || this.character == '-') {
                string = string + this.character;
                this.getNextCharacter();
            }
            while (this.character >= '0' && this.character <= '9') {
                string = string + this.character;
                this.getNextCharacter();
            }
        }
        try {
            d = Double.valueOf(string);
        }
        catch (NumberFormatException numberFormatException) {
            this.position = this.start;
            throw new ParserException(1);
        }
        this.number[this.num++] = d;
        this.addCode('\u012c');
    }

    private void scanNonNumeric() throws ParserException {
        int n;
        String string = "";
        if (this.character == '*' || this.character == '/' || this.character == ')' || this.character == '!' || this.character == ',' || this.character == '<' || this.character == '>' || this.character == '=' || this.character == '&' || this.character == '|') {
            throw new ParserException(1);
        }
        do {
            string = string + this.character;
            this.getNextCharacter();
        } while (this.character != ' ' && this.character != '+' && this.character != '-' && this.character != '*' && this.character != '/' && this.character != '!' && this.character != '(' && this.character != ')' && this.character != ',' && this.character != '<' && this.character != '>' && this.character != '=' && this.character != '&' && this.character != '|');
        for (n = 0; n < NO_CONST; ++n) {
            if (!string.equals(constname[n])) continue;
            this.addCode((char)(n + 253));
            return;
        }
        for (n = 0; n < NO_FUNCS; ++n) {
            if (!string.equals(funcname[n])) continue;
            this.skipSpaces();
            if (this.character != '(') {
                throw new ParserException(2);
            }
            this.scanAndParse();
            if (this.character != ')') {
                throw new ParserException(2);
            }
            this.getNextCharacter();
            this.addCode((char)(n + 1000));
            return;
        }
        for (n = 0; n < NO_EXT_FUNCS; ++n) {
            if (!string.equals(extfunc[n])) continue;
            this.skipSpaces();
            if (this.character != '(') {
                throw new ParserException(2);
            }
            this.scanAndParse();
            if (this.character != ',') {
                throw new ParserException(11);
            }
            String string2 = new String(this.postfix_code);
            this.postfix_code = "";
            this.scanAndParse();
            if (this.character != ')') {
                throw new ParserException(2);
            }
            this.getNextCharacter();
            string2 = string2 + this.postfix_code;
            this.postfix_code = new String(string2);
            this.addCode((char)(n + EXT_FUNC_OFFSET));
            return;
        }
        for (n = 0; n < NO_FUNCSNOPARAM; ++n) {
            if (!string.equals(funcnameNoParam[n])) continue;
            this.skipSpaces();
            if (this.character != '(') {
                throw new ParserException(2);
            }
            this.skipSpaces();
            this.getNextCharacter();
            if (this.character != ')') {
                throw new ParserException(2);
            }
            this.getNextCharacter();
            this.addCode((char)(n + FUNCNOPARAM_OFFSET));
            return;
        }
        for (n = 0; n < this.var_count; ++n) {
            if (!string.equals(this.var_name[n])) continue;
            this.addCode((char)(n + 2000));
            return;
        }
        n = this.refnames.indexOf(string);
        if (n != -1) {
            this.addCode((char)(n + 3000));
            return;
        }
        this.position = this.start;
        throw new ParserException(5);
    }

    private boolean getIdentifier() throws ParserException {
        boolean bl = false;
        this.getNextCharacter();
        this.skipSpaces();
        if (this.character == '!') {
            this.getNextCharacter();
            this.skipSpaces();
            if (this.character != '(') {
                throw new ParserException(2);
            }
            this.scanAndParse();
            if (this.character != ')') {
                throw new ParserException(2);
            }
            if (!this.ISBOOLEAN) {
                throw new ParserException(12);
            }
            this.addCode('\f');
            this.getNextCharacter();
            return false;
        }
        this.ISBOOLEAN = false;
        while (this.character == '+' || this.character == '-') {
            if (this.character == '-') {
                bl = !bl;
            }
            this.getNextCharacter();
            this.skipSpaces();
        }
        this.start = this.position;
        if (this.character >= '0' && this.character <= '9' || this.character == '.') {
            this.scanNumber();
        } else if (this.character == '(') {
            this.scanAndParse();
            this.getNextCharacter();
        } else {
            this.scanNonNumeric();
        }
        this.skipSpaces();
        return bl;
    }

    private void arithmeticLevel2() throws ParserException {
        if (this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        do {
            char c = this.character;
            boolean bl = this.getIdentifier();
            if (this.ISBOOLEAN) {
                throw new ParserException(12);
            }
            if (bl) {
                this.addCode('_');
            }
            this.addCode(c);
        } while (this.character == '*' || this.character == '/');
    }

    private void arithmeticLevel1() throws ParserException {
        if (this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        do {
            char c = this.character;
            boolean bl = this.getIdentifier();
            if (this.ISBOOLEAN) {
                throw new ParserException(12);
            }
            if (this.character == '*' || this.character == '/') {
                if (bl) {
                    this.addCode('_');
                }
                this.arithmeticLevel2();
            }
            this.addCode(c);
        } while (this.character == '+' || this.character == '-');
    }

    private void relationLevel() throws ParserException {
        int n = 0;
        if (this.INRELATION) {
            throw new ParserException(13);
        }
        this.INRELATION = true;
        if (this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        switch (this.character) {
            case '!': {
                n = 12;
                this.getNextCharacter();
                if (this.character == '=') {
                    n = 6;
                    break;
                }
                --this.position;
                break;
            }
            case '=': {
                n = 7;
                this.getNextCharacter();
                if (this.character == '=') {
                    n = 7;
                    break;
                }
                --this.position;
                break;
            }
            case '<': {
                n = 2;
                this.getNextCharacter();
                if (this.character == '>') {
                    n = 6;
                    break;
                }
                if (this.character == '=') {
                    n = 4;
                    break;
                }
                --this.position;
                break;
            }
            case '>': {
                n = 3;
                this.getNextCharacter();
                if (this.character == '=') {
                    n = 5;
                    break;
                }
                --this.position;
            }
        }
        this.scanAndParse();
        this.INRELATION = false;
        if (this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        this.addCode((char)n);
        this.ISBOOLEAN = true;
    }

    private void booleanLevel() throws ParserException {
        if (!this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        char c = this.character;
        this.scanAndParse();
        if (!this.ISBOOLEAN) {
            throw new ParserException(12);
        }
        switch (c) {
            case '&': {
                this.addCode('\n');
                break;
            }
            case '|': {
                this.addCode('\u000b');
            }
        }
    }

    private void scanAndParse() throws ParserException {
        boolean bl = this.getIdentifier();
        if (bl) {
            this.addCode('_');
        }
        block7: while (true) {
            switch (this.character) {
                case '+': 
                case '-': {
                    this.arithmeticLevel1();
                    continue block7;
                }
                case '*': 
                case '/': {
                    this.arithmeticLevel2();
                    continue block7;
                }
                case ')': 
                case ',': {
                    return;
                }
                case '!': 
                case '<': 
                case '=': 
                case '>': {
                    this.relationLevel();
                    continue block7;
                }
                case '&': 
                case '|': {
                    this.booleanLevel();
                    continue block7;
                }
            }
            break;
        }
        throw new ParserException(6);
    }

    private void parseSubFunction() {
        block3: {
            this.position = 0;
            this.postfix_code = "";
            this.INRELATION = false;
            this.ISBOOLEAN = false;
            try {
                this.scanAndParse();
            }
            catch (ParserException parserException) {
                this.error = parserException.getErrorCode();
                if (this.error != 1 || this.postfix_code != "") break block3;
                this.error = 4;
            }
        }
        if (this.error == 0 && this.position != this.function.length()) {
            this.error = 7;
        }
    }

    private double builtInFunction(int n, double d) {
        switch (n) {
            case 0: {
                return Math.abs(d);
            }
            case 1: {
                return Math.acos(d);
            }
            case 2: {
                return Math.asin(d);
            }
            case 3: {
                return Math.atan(d);
            }
            case 4: {
                return Math.ceil(d);
            }
            case 5: {
                return Math.cos(d);
            }
            case 6: {
                return Math.exp(d);
            }
            case 7: {
                return Math.floor(d);
            }
            case 8: {
                return Math.log(d);
            }
            case 9: {
                return Math.rint(d);
            }
            case 10: {
                return Math.round(d);
            }
            case 11: {
                return Math.sin(d);
            }
            case 12: {
                return Math.sqrt(d);
            }
            case 13: {
                return Math.tan(d);
            }
            case 14: {
                return Math.toDegrees(d);
            }
            case 15: {
                return Math.toRadians(d);
            }
        }
        this.error = 8;
        return Double.NaN;
    }

    private double builtInFunctionNoParam(int n) {
        switch (n) {
            case 0: {
                return Math.random();
            }
        }
        this.error = 8;
        return Double.NaN;
    }

    private double builtInExtFunction(int n, double d, double d2) {
        switch (n) {
            case 0: {
                return Math.atan2(d, d2);
            }
            case 1: {
                return Math.IEEEremainder(d, d2);
            }
            case 2: {
                return Math.max(d, d2);
            }
            case 3: {
                return Math.min(d, d2);
            }
            case 4: {
                return Math.pow(d, d2);
            }
        }
        this.error = 8;
        return Double.NaN;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private double evaluateSubFunction() {
        int n = -1;
        int n2 = 0;
        int n3 = this.postfix_code.length();
        block25: while (true) {
            char c;
            try {
                if (n2 == n3) {
                    return this.stack[0];
                }
                c = this.postfix_code.charAt(n2++);
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                return this.stack[0];
            }
            try {
                switch (c) {
                    case '+': {
                        int n4 = n - 1;
                        this.stack[n4] = this.stack[n4] + this.stack[n];
                        --n;
                        continue block25;
                    }
                    case '-': {
                        int n5 = n - 1;
                        this.stack[n5] = this.stack[n5] - this.stack[n];
                        --n;
                        continue block25;
                    }
                    case '*': {
                        int n6 = n - 1;
                        this.stack[n6] = this.stack[n6] * this.stack[n];
                        --n;
                        continue block25;
                    }
                    case '/': {
                        if (this.stack[n] != 0.0) {
                            int n7 = n - 1;
                            this.stack[n7] = this.stack[n7] / this.stack[n];
                        } else {
                            int n8 = n - 1;
                            this.stack[n8] = this.stack[n8] / 1.0E-128;
                        }
                        --n;
                        continue block25;
                    }
                    case '_': {
                        this.stack[n] = -this.stack[n];
                        continue block25;
                    }
                    case '\u0001': {
                        int n9 = n2 + this.postfix_code.charAt(n2++);
                        while (true) {
                            if (n2 >= n9) continue block25;
                            if (this.postfix_code.charAt(n2++) != '\u012c') continue;
                            ++this.numberindex;
                        }
                    }
                    case '\u0002': {
                        double d = this.stack[--n] < this.stack[n + 1] ? 1.0 : 0.0;
                        this.stack[n] = d;
                        continue block25;
                    }
                    case '\u0003': {
                        double d = this.stack[--n] > this.stack[n + 1] ? 1.0 : 0.0;
                        this.stack[n] = d;
                        continue block25;
                    }
                    case '\u0004': {
                        double d = this.stack[--n] <= this.stack[n + 1] ? 1.0 : 0.0;
                        this.stack[n] = d;
                        continue block25;
                    }
                    case '\u0005': {
                        double d = this.stack[--n] >= this.stack[n + 1] ? 1.0 : 0.0;
                        this.stack[n] = d;
                        continue block25;
                    }
                    case '\u0007': {
                        double d = this.stack[--n] == this.stack[n + 1] ? 1.0 : 0.0;
                        this.stack[n] = d;
                        continue block25;
                    }
                    case '\u0006': {
                        double d = this.stack[--n] != this.stack[n + 1] ? 1.0 : 0.0;
                        this.stack[n] = d;
                        continue block25;
                    }
                    case '\b': {
                        int n9;
                        if (this.stack[n--] == 0.0) {
                            n9 = n2 + this.postfix_code.charAt(n2++);
                            while (true) {
                                if (n2 >= n9) continue block25;
                                if (this.postfix_code.charAt(n2++) != '\u012c') continue;
                                ++this.numberindex;
                            }
                        }
                        ++n2;
                        continue block25;
                    }
                    case '\t': {
                        continue block25;
                    }
                    case '\n': {
                        if (this.stack[--n] != 0.0 && this.stack[n + 1] != 0.0) {
                            this.stack[n] = 1.0;
                            continue block25;
                        }
                        this.stack[n] = 0.0;
                        continue block25;
                    }
                    case '\u000b': {
                        if (this.stack[--n] != 0.0 || this.stack[n + 1] != 0.0) {
                            this.stack[n] = 1.0;
                            continue block25;
                        }
                        this.stack[n] = 0.0;
                        continue block25;
                    }
                    case '\f': {
                        this.stack[n] = this.stack[n] == 0.0 ? 1.0 : 0.0;
                        continue block25;
                    }
                    case '\u012c': {
                        this.stack[++n] = this.number[this.numberindex++];
                        continue block25;
                    }
                }
                if (c >= '\u0bb8') {
                    this.stack[++n] = this.refvalue[c - 3000];
                    continue;
                }
                if (c >= '\u07d0') {
                    this.stack[++n] = this.var_value[c - 2000];
                    continue;
                }
                if (c >= FUNCNOPARAM_OFFSET) {
                    this.stack[++n] = this.builtInFunctionNoParam(c - FUNCNOPARAM_OFFSET);
                    continue;
                }
                if (c >= EXT_FUNC_OFFSET) {
                    this.stack[n - 1] = this.builtInExtFunction(c - EXT_FUNC_OFFSET, this.stack[n - 1], this.stack[n]);
                    --n;
                    continue;
                }
                if (c >= '\u03e8') {
                    this.stack[n] = this.builtInFunction(c - 1000, this.stack[n]);
                    continue;
                }
                if (c < '\u00fd') {
                    this.error = 8;
                    return Double.NaN;
                }
                this.stack[++n] = constvalue[c - 253];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                this.error = 9;
                return Double.NaN;
            }
            catch (NullPointerException nullPointerException) {
                this.error = 8;
                return Double.NaN;
            }
        }
    }
}

