/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;
import org.opensourcephysics.ejs.control.value.ParserSuryono;

class MyCoordinateStringBuilder
extends CoordinateStringBuilder {
    DecimalFormat xFormat = new DecimalFormat("x=0.000;x=-0.000");
    DecimalFormat yFormat = new DecimalFormat("y=0.000;y=-0.000");
    ParserSuryono parser = null;
    DecimalFormat expressionFormat = new DecimalFormat("0.000;-0.000");

    MyCoordinateStringBuilder() {
    }

    public void setXFormat(DecimalFormat decimalFormat) {
        this.xFormat = decimalFormat;
    }

    public void setYFormat(DecimalFormat decimalFormat) {
        this.yFormat = decimalFormat;
    }

    public void setExpressionFormat(DecimalFormat decimalFormat) {
        this.expressionFormat = decimalFormat;
    }

    public void setExpression(String string) {
        if (string == null) {
            this.parser = null;
            return;
        }
        this.parser = new ParserSuryono(2);
        this.parser.defineVariable(0, "x");
        this.parser.defineVariable(1, "y");
        this.parser.define(string);
        this.parser.parse();
    }

    public String getCoordinateString(DrawingPanel drawingPanel, MouseEvent mouseEvent) {
        String string = "";
        double d = drawingPanel.pixToX(mouseEvent.getPoint().x);
        double d2 = drawingPanel.pixToY(mouseEvent.getPoint().y);
        if (this.xFormat != null) {
            string = this.yFormat != null ? this.xFormat.format(d) + " " + this.yFormat.format(d2) : this.xFormat.format(d);
        } else if (this.yFormat != null) {
            string = this.yFormat.format(d2);
        }
        if (this.parser != null) {
            this.parser.setVariable(0, d);
            this.parser.setVariable(1, d2);
            if (string.length() > 0) {
                string = string + " ";
            }
            string = string + this.expressionFormat.format(this.parser.evaluate());
        }
        return string;
    }
}

