/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JToolBar;
import javax.swing.border.EmptyBorder;
import org.opensourcephysics.ejs.control.swing.ControlContainer;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlToolBar
extends ControlContainer {
    protected static int TOOLBAR_ADDED = 6;
    protected JToolBar bar;
    private LayoutManager myLayout = null;
    private LayoutManager defLayout;
    private Rectangle myBorder = null;
    private static ArrayList infoList = null;

    public ControlToolBar(Object object) {
        super(object);
    }

    protected Component createVisual(Object object) {
        this.bar = object instanceof JToolBar ? (JToolBar)object : new JToolBar();
        this.defLayout = this.bar.getLayout();
        return this.bar;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("borderPainted");
            infoList.add("floatable");
            infoList.add("layout");
            infoList.add("border");
            infoList.add("orientation");
            infoList.add("rollOver");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("borderPainted")) {
            return "boolean";
        }
        if (string.equals("floatable")) {
            return "boolean";
        }
        if (string.equals("layout")) {
            return "Layout|Object NO_RESET";
        }
        if (string.equals("border")) {
            return "Margins|Object";
        }
        if (string.equals("orientation")) {
            return "Orientation|int";
        }
        if (string.equals("rollOver")) {
            return "boolean";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                this.bar.setBorderPainted(value.getBoolean());
                break;
            }
            case 1: {
                this.bar.setFloatable(value.getBoolean());
                break;
            }
            case 2: {
                LayoutManager layoutManager;
                if (!(value.getObject() instanceof LayoutManager) || (layoutManager = (LayoutManager)value.getObject()) == this.myLayout) break;
                this.myLayout = layoutManager;
                this.bar.setLayout(this.myLayout);
                this.adjustChildren();
                this.bar.validate();
                break;
            }
            case 3: {
                Rectangle rectangle;
                if (!(value.getObject() instanceof Rectangle) || (rectangle = (Rectangle)value.getObject()) == this.myBorder) break;
                this.bar.setBorder(new EmptyBorder(rectangle.x, rectangle.y, rectangle.width, rectangle.height));
                this.myBorder = rectangle;
                break;
            }
            case 4: {
                if (this.bar.getOrientation() == value.getInteger()) break;
                this.bar.setOrientation(value.getInteger());
                break;
            }
            case 5: {
                this.bar.setRollover(value.getBoolean());
                break;
            }
            default: {
                super.setValue(n - TOOLBAR_ADDED, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.bar.setBorderPainted(true);
                break;
            }
            case 1: {
                this.bar.setFloatable(true);
                break;
            }
            case 2: {
                this.myLayout = this.defLayout;
                this.bar.setLayout(this.myLayout);
                this.adjustChildren();
                this.bar.validate();
                break;
            }
            case 3: {
                this.bar.setBorder(null);
                this.myBorder = null;
                break;
            }
            case 4: {
                this.bar.setOrientation(0);
                break;
            }
            case 5: {
                this.bar.setRollover(false);
                break;
            }
            default: {
                super.setDefaultValue(n - TOOLBAR_ADDED);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return null;
            }
        }
        return super.getValue(n - TOOLBAR_ADDED);
    }
}

