/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.util.ArrayList;
import javax.swing.JMenuBar;
import javax.swing.JRootPane;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.swing.ControlContainer;
import org.opensourcephysics.ejs.control.swing.ControlMenuBar;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlRootPane
extends ControlContainer {
    protected JRootPane panel;
    private LayoutManager myLayout = null;
    protected JMenuBar menubar = null;
    private static ArrayList infoList = null;

    public ControlRootPane(Object object) {
        super(object);
    }

    protected Component createVisual(Object object) {
        this.panel = object instanceof JRootPane ? (JRootPane)object : new JRootPane();
        return this.panel;
    }

    public Component getComponent() {
        return this.panel;
    }

    public Container getContainer() {
        return this.panel.getContentPane();
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("layout");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("layout")) {
            return "Layout|Object NO_RESET";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                LayoutManager layoutManager;
                if (!(value.getObject() instanceof LayoutManager) || (layoutManager = (LayoutManager)value.getObject()) == this.myLayout) break;
                this.myLayout = layoutManager;
                this.getContainer().setLayout(this.myLayout);
                this.adjustChildren();
                this.panel.validate();
                break;
            }
            default: {
                super.setValue(n - 1, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.myLayout = new BorderLayout();
                this.getContainer().setLayout(this.myLayout);
                this.adjustChildren();
                this.panel.validate();
                break;
            }
            default: {
                super.setDefaultValue(n - 1);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return null;
            }
        }
        return super.getValue(n - 1);
    }

    public void add(ControlElement controlElement) {
        if (!(controlElement instanceof ControlMenuBar)) {
            super.add(controlElement);
            return;
        }
        this.children.add(controlElement);
        this.menubar = (JMenuBar)controlElement.getVisual();
        this.panel.setJMenuBar(this.menubar);
        this.propagateProperty(controlElement, "font", this.getPropagatedProperty("font"));
        this.propagateProperty(controlElement, "foreground", this.getPropagatedProperty("foreground"));
        this.propagateProperty(controlElement, "background", this.getPropagatedProperty("background"));
    }

    public void remove(ControlElement controlElement) {
        if (!(controlElement instanceof ControlMenuBar)) {
            super.remove(controlElement);
            return;
        }
        this.children.remove(controlElement);
        this.menubar = null;
        this.panel.setJMenuBar(null);
        this.panel.validate();
        this.panel.repaint();
    }
}

