/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.JLabel;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.ejs.control.swing.ControlSwingElement;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlLabel
extends ControlSwingElement {
    private static final int LABEL_ADDED = 6;
    protected JLabel label;
    private String imageFile = null;
    private String labelString = "";
    private static ArrayList infoList = null;

    public ControlLabel(Object object) {
        super(object);
    }

    protected Component createVisual(Object object) {
        this.label = object instanceof JLabel ? (JLabel)object : new JLabel();
        this.label.setOpaque(true);
        this.label.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                ControlLabel.this.invokeActions(20);
            }

            public void mouseClicked(MouseEvent mouseEvent) {
                ControlLabel.this.invokeActions();
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                ControlLabel.this.invokeActions(21);
            }
        });
        return this.label;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("text");
            infoList.add("image");
            infoList.add("alignment");
            infoList.add("action");
            infoList.add("pressAction");
            infoList.add("releaseAction");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("text")) {
            return "String NotTrimmed TRANSLATABLE";
        }
        if (string.equals("image")) {
            return "File|String TRANSLATABLE";
        }
        if (string.equals("alignment")) {
            return "Alignment|int";
        }
        if (string.equals("action")) {
            return "Action CONSTANT";
        }
        if (string.equals("pressAction")) {
            return "Action CONSTANT";
        }
        if (string.equals("releaseAction")) {
            return "Action CONSTANT";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (this.labelString.equals(value.getString())) break;
                this.labelString = value.getString();
                this.label.setText(GUIUtils.parseTeX(value.getString()));
                break;
            }
            case 1: {
                if (value.getString().equals(this.imageFile)) {
                    return;
                }
                this.imageFile = value.getString();
                this.label.setIcon(this.getIcon(this.imageFile));
                break;
            }
            case 2: {
                this.label.setHorizontalAlignment(value.getInteger());
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, value.getString());
                break;
            }
            case 4: {
                this.removeAction(20, this.getProperty("pressAction"));
                this.addAction(20, value.getString());
                break;
            }
            case 5: {
                this.removeAction(21, this.getProperty("releaseAction"));
                this.addAction(21, value.getString());
                break;
            }
            default: {
                super.setValue(n - 6, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.labelString = "";
                this.label.setText("");
                break;
            }
            case 1: {
                this.label.setIcon(null);
                this.imageFile = null;
                break;
            }
            case 2: {
                this.label.setHorizontalAlignment(0);
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            case 4: {
                this.removeAction(20, this.getProperty("pressAction"));
                break;
            }
            case 5: {
                this.removeAction(21, this.getProperty("releaseAction"));
                break;
            }
            default: {
                super.setDefaultValue(n - 6);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return null;
            }
        }
        return super.getValue(n - 6);
    }
}

