/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import org.opensourcephysics.display.GUIUtils;
import org.opensourcephysics.ejs.control.swing.ControlSwingElement;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlButton
extends ControlSwingElement {
    protected JButton button;
    private String imageFile = null;
    private String labelString = "";
    private static ArrayList infoList = null;

    public ControlButton(Object object) {
        super(object);
    }

    protected Component createVisual(Object object) {
        this.button = object instanceof JButton ? (JButton)object : new JButton();
        this.button.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ControlButton.this.invokeActions();
            }
        });
        return this.button;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("text");
            infoList.add("image");
            infoList.add("alignment");
            infoList.add("action");
            infoList.add("mnemonic");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("text")) {
            return "String NotTrimmed TRANSLATABLE";
        }
        if (string.equals("image")) {
            return "File|String TRANSLATABLE";
        }
        if (string.equals("alignment")) {
            return "Alignment|int";
        }
        if (string.equals("action")) {
            return "Action CONSTANT";
        }
        if (string.equals("mnemonic")) {
            return "String  TRANSLATABLE";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (this.labelString.equals(value.getString())) break;
                this.labelString = value.getString();
                this.button.setText(GUIUtils.parseTeX(value.getString()));
                break;
            }
            case 1: {
                if (value.getString().equals(this.imageFile)) {
                    return;
                }
                this.imageFile = value.getString();
                this.button.setIcon(this.getIcon(this.imageFile));
                break;
            }
            case 2: {
                this.button.setHorizontalAlignment(value.getInteger());
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("action"));
                this.addAction(0, value.getString());
                break;
            }
            case 4: {
                this.button.setMnemonic(value.getString().charAt(0));
                break;
            }
            default: {
                super.setValue(n - 5, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.labelString = "";
                this.button.setText("");
                break;
            }
            case 1: {
                this.imageFile = null;
                this.button.setIcon(null);
                break;
            }
            case 2: {
                this.button.setHorizontalAlignment(0);
                break;
            }
            case 3: {
                this.removeAction(0, this.getProperty("action"));
                break;
            }
            case 4: {
                this.button.setMnemonic(-1);
                break;
            }
            default: {
                super.setDefaultValue(n - 5);
            }
        }
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return null;
            }
        }
        return super.getValue(n - 5);
    }
}

