/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.drawables;

import java.io.File;
import java.util.ArrayList;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.ejs.Simulation;
import org.opensourcephysics.ejs.control.swing.ControlDrawable;
import org.opensourcephysics.ejs.control.value.IntegerValue;
import org.opensourcephysics.ejs.control.value.Value;
import org.opensourcephysics.media.quicktime.QTVideo;

public class ControlVideo
extends ControlDrawable {
    static final double TO_RAD = Math.PI / 180;
    private QTVideo video;
    private double x = 0.0;
    private double y = 0.0;
    private double dx = 1.0;
    private double dy = 1.0;
    private double angle = 0.0;
    private int frame = 0;
    private int iangle = 0;
    private boolean visible = true;
    private String videofile = null;
    private static ArrayList infoList = null;

    public ControlVideo(Object object) {
        super(object);
    }

    protected Drawable createDrawable(Object object) {
        if (object instanceof QTVideo) {
            this.video = (QTVideo)object;
        } else {
            try {
                this.video = new QTVideo("");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.video.setVisible(false);
        return this.video;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("x");
            infoList.add("y");
            infoList.add("sizex");
            infoList.add("sizey");
            infoList.add("angle");
            infoList.add("videofile");
            infoList.add("frame");
            infoList.add("visible");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyCommonName(String string) {
        if (string.equals("angle")) {
            return "rotationAngle";
        }
        if (string.equals("sizex")) {
            return "sizeX";
        }
        if (string.equals("sizey")) {
            return "sizeY";
        }
        return super.getPropertyCommonName(string);
    }

    public String getPropertyInfo(String string) {
        if (string.equals("x")) {
            return "int|double";
        }
        if (string.equals("y")) {
            return "int|double";
        }
        if (string.equals("sizex")) {
            return "int|double";
        }
        if (string.equals("angle")) {
            return "int|double";
        }
        if (string.equals("videofile")) {
            return "File|String";
        }
        if (string.equals("frame")) {
            return "int";
        }
        if (string.equals("visible")) {
            return "boolean";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getDouble() == this.x) break;
                this.x = value.getDouble();
                if (this.videofile == null) break;
                this.video.setX(this.x);
                break;
            }
            case 1: {
                if (value.getDouble() == this.y) break;
                this.y = value.getDouble();
                if (this.videofile == null) break;
                this.video.setY(this.y);
                break;
            }
            case 2: {
                if (value.getDouble() == this.dx) break;
                this.dx = value.getDouble();
                if (this.videofile == null) break;
                this.video.setWidth(this.dx);
                break;
            }
            case 3: {
                if (value.getDouble() == this.dy) break;
                this.dy = value.getDouble();
                if (this.videofile == null) break;
                this.video.setHeight(this.dy);
                break;
            }
            case 4: {
                if (value instanceof IntegerValue) {
                    if (value.getInteger() == this.iangle) break;
                    this.iangle = value.getInteger();
                    this.angle = (double)this.iangle * (Math.PI / 180);
                    if (this.videofile == null) break;
                    this.video.setAngle(this.angle);
                    break;
                }
                if (value.getDouble() == this.angle) break;
                this.angle = value.getDouble();
                this.iangle = (int)(this.angle / (Math.PI / 180));
                if (this.videofile == null) break;
                this.video.setAngle(this.angle);
                break;
            }
            case 5: {
                this.setVideoFile(value.getString());
                break;
            }
            case 6: {
                if (value.getInteger() == this.frame) break;
                this.frame = value.getInteger();
                if (this.videofile == null) break;
                this.video.setFrameNumber(this.frame);
                break;
            }
            case 7: {
                this.visible = value.getBoolean();
                if (this.videofile == null) break;
                this.video.setVisible(this.visible);
                break;
            }
            default: {
                super.setValue(n - 8, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                this.x = 0.0;
                if (this.videofile == null) break;
                this.video.setX(this.x);
                break;
            }
            case 1: {
                this.y = 0.0;
                if (this.videofile == null) break;
                this.video.setY(this.y);
                break;
            }
            case 2: {
                this.dx = 1.0;
                if (this.videofile == null) break;
                this.video.setWidth(this.dx);
                break;
            }
            case 3: {
                this.dy = 1.0;
                if (this.videofile == null) break;
                this.video.setHeight(this.dy);
                break;
            }
            case 4: {
                this.iangle = 0;
                this.angle = 0.0;
                if (this.videofile == null) break;
                this.video.setAngle(this.angle);
                break;
            }
            case 5: {
                this.setVideoFile(null);
                break;
            }
            case 6: {
                this.frame = 0;
                if (this.videofile == null) break;
                this.video.setFrameNumber(this.frame);
                break;
            }
            case 7: {
                this.visible = true;
                if (this.videofile == null) break;
                this.video.setVisible(this.visible);
                break;
            }
            default: {
                super.setDefaultValue(n - 8);
            }
        }
    }

    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return "0";
            }
            case 2: 
            case 3: {
                return "1";
            }
            case 4: {
                return "0";
            }
            case 5: {
                return "<none>";
            }
            case 6: {
                return "0";
            }
            case 7: {
                return "true";
            }
        }
        return super.getDefaultValueString(n - 8);
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return null;
            }
        }
        return super.getValue(n - 8);
    }

    private void setVideoFile(String string) {
        if (string == null || string.trim().length() <= 0) {
            this.videofile = null;
            this.video.setVisible(false);
            return;
        }
        if (this.videofile != null && this.videofile.equals(string)) {
            return;
        }
        this.videofile = this.setVideo(string) ? string : null;
        if (this.videofile != null) {
            this.video.setX(this.x);
            this.video.setY(this.y);
            this.video.setWidth(this.dx);
            this.video.setAngle(this.angle);
            this.video.setFrameNumber(this.frame);
            this.video.setVisible(this.visible);
        } else {
            this.video.setVisible(false);
        }
    }

    private boolean setVideo(String string) {
        try {
            File file = Simulation.requiresResourceFile(string);
            if (file != null) {
                this.video.load(file);
                return true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return false;
    }

    public void onExit() {
        super.destroy();
    }
}

