/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.displayejs;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.InteractiveTrace;
import org.opensourcephysics.displayejs.TraceSet;
import org.opensourcephysics.ejs.Simulation;
import org.opensourcephysics.ejs.control.ControlElement;
import org.opensourcephysics.ejs.control.DataCollector;
import org.opensourcephysics.ejs.control.Resetable;
import org.opensourcephysics.ejs.control.displayejs.ControlElementSet;
import org.opensourcephysics.ejs.control.swing.NeedsPreUpdate;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlTraceSet
extends ControlElementSet
implements NeedsPreUpdate,
Resetable,
DataCollector {
    protected static final int TRACESET_ADDED = 12;
    protected static final int INPUT_X = 16;
    protected static final int INPUT_Y = 17;
    protected static final int INPUT_Z = 18;
    protected static final int MY_STYLE = 30;
    protected boolean norepeat;
    protected boolean isSet = false;
    protected int elements = 0;
    protected double[] x;
    protected double[] y;
    protected double[] z;
    protected double[] xOne;
    protected double[] yOne;
    protected double[] zOne;
    protected String name = "";
    private static ArrayList infoList = null;
    private static final int[] posSpot = new int[]{6, 7, 8};
    private static final int[] sizeSpot = new int[]{19, 20, 21};

    public ControlTraceSet(Object object) {
        super(object);
    }

    protected Drawable createDrawable(Object object) {
        this.xOne = new double[]{0.0};
        this.x = this.xOne;
        this.yOne = new double[]{0.0};
        this.y = this.yOne;
        this.zOne = new double[]{0.0};
        this.z = this.zOne;
        this.norepeat = false;
        this.elementSet = object instanceof ElementSet ? (ElementSet)object : new TraceSet(1);
        ((InteractiveTrace)this.elementSet.elementAt(0)).setAllowTable(true);
        return this.elementSet;
    }

    protected void setName(String string) {
        this.elementSet.setName(string);
    }

    public void initialize() {
        int n = this.elementSet.getNumberOfElements();
        for (int i = 0; i < n; ++i) {
            ((InteractiveTrace)this.elementSet.elementAt(i)).initialize();
        }
        this.zOne[0] = 0.0;
        this.yOne[0] = 0.0;
        this.xOne[0] = 0.0;
        this.x = this.xOne;
        this.y = this.yOne;
        this.z = this.zOne;
    }

    public void reset() {
        int n = this.elementSet.getNumberOfElements();
        for (int i = 0; i < n; ++i) {
            ((InteractiveTrace)this.elementSet.elementAt(i)).clear();
        }
        this.zOne[0] = 0.0;
        this.yOne[0] = 0.0;
        this.xOne[0] = 0.0;
        this.x = this.xOne;
        this.y = this.yOne;
        this.z = this.zOne;
    }

    public void onExit() {
        int n = this.elementSet.getNumberOfElements();
        for (int i = 0; i < n; ++i) {
            ((InteractiveTrace)this.elementSet.elementAt(i)).clear();
        }
    }

    public void flush() {
        int n = this.elementSet.getNumberOfElements();
        for (int i = 0; i < n; ++i) {
            ((InteractiveTrace)this.elementSet.elementAt(i)).flush();
        }
    }

    public void preupdate() {
        if (!this.isSet) {
            return;
        }
        int n = this.x.length - 1;
        int n2 = this.y.length - 1;
        int n3 = this.z.length - 1;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = this.elementSet.getNumberOfElements();
        for (int i = 0; i < n7; ++i) {
            ((InteractiveTrace)this.elementSet.elementAt(i)).addPoint(this.x[n4], this.y[n5], this.z[n6]);
            if (n4 < n) {
                ++n4;
            }
            if (n5 < n2) {
                ++n5;
            }
            if (n6 >= n3) continue;
            ++n6;
        }
        this.isSet = false;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("maxpoints");
            infoList.add("skippoints");
            infoList.add("active");
            infoList.add("norepeat");
            infoList.add("connected");
            infoList.add("markersize");
            infoList.add("positionx");
            infoList.add("positiony");
            infoList.add("positionz");
            infoList.add("memory");
            infoList.add("drivenby");
            infoList.add("memorycolor");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyCommonName(String string) {
        if (string.equals("x")) {
            return "inputX";
        }
        if (string.equals("y")) {
            return "inputY";
        }
        if (string.equals("z")) {
            return "inputZ";
        }
        if (string.equals("color")) {
            return "lineColor";
        }
        if (string.equals("secondaryColor")) {
            return "fillColor";
        }
        if (string.equals("maxpoints")) {
            return "maximumPoints";
        }
        return super.getPropertyCommonName(string);
    }

    public String getPropertyInfo(String string) {
        if (string.equals("maxpoints")) {
            return "int|int[] PREVIOUS";
        }
        if (string.equals("skippoints")) {
            return "int|int[]";
        }
        if (string.equals("active")) {
            return "boolean|boolean[]";
        }
        if (string.equals("norepeat")) {
            return "boolean|boolean[]";
        }
        if (string.equals("connected")) {
            return "boolean|boolean[]";
        }
        if (string.equals("style")) {
            return "MarkerShape|int|int[]";
        }
        if (string.equals("markersize")) {
            return "int|int[]";
        }
        if (string.equals("positionx")) {
            return "int|double|double[]";
        }
        if (string.equals("positiony")) {
            return "int|double|double[]";
        }
        if (string.equals("positionz")) {
            return "int|double|double[] DEPRECATED";
        }
        if (string.equals("memory")) {
            return "int|int[]";
        }
        if (string.equals("drivenby")) {
            return "DrivenBy|int|int[]";
        }
        if (string.equals("memorycolor")) {
            return "Color|Object|Object[]";
        }
        return super.getPropertyInfo(string);
    }

    public void addMenuEntries() {
        if (this.getMenuNameEntry() == null) {
            return;
        }
        ArrayList<AbstractAction> arrayList = new ArrayList<AbstractAction>();
        arrayList.add(new AbstractAction(Simulation.getEjsString("InteractiveTrace.ShowDataTable")){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog(Simulation.getEjsString("ElementSet.SelectElement"));
                try {
                    int n = Integer.parseInt(string);
                    ((InteractiveTrace)ControlTraceSet.this.elementSet.elementAt(n)).showTable(ControlTraceSet.this.getParent().getVisual());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        arrayList.add(new AbstractAction(Simulation.getEjsString("InteractiveTrace.ShowDatasetTool")){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = JOptionPane.showInputDialog("Please input a value");
                try {
                    int n = Integer.parseInt(string);
                    ((InteractiveTrace)ControlTraceSet.this.elementSet.elementAt(n)).showDatasetTool();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        arrayList.add(new AbstractAction(Simulation.getEjsString("InteractiveTrace.ShowDatasetManager")){

            public void actionPerformed(ActionEvent actionEvent) {
                InteractiveTrace.showDatasetManagerTool(ControlTraceSet.this.getParent().getVisual());
            }
        });
        this.getSimulation().addElementMenuEntries(this.getMenuNameEntry(), arrayList);
    }

    public ControlElement setProperty(String string, String string2) {
        if ((string = string.trim()).equals("makershape")) {
            return super.setProperty("style", string2);
        }
        if (string.equals("linecolor")) {
            return super.setProperty("color", string2);
        }
        if (string.equals("markercolor")) {
            return super.setProperty("secondaryColor", string2);
        }
        return super.setProperty(string, string2);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 16: {
                if (value.getObject() instanceof double[]) {
                    this.x = (double[])value.getObject();
                } else {
                    this.xOne[0] = value.getDouble();
                    this.x = this.xOne;
                }
                this.isSet = true;
                break;
            }
            case 17: {
                if (value.getObject() instanceof double[]) {
                    this.y = (double[])value.getObject();
                } else {
                    this.yOne[0] = value.getDouble();
                    this.y = this.yOne;
                }
                this.isSet = true;
                break;
            }
            case 18: {
                if (value.getObject() instanceof double[]) {
                    this.z = (double[])value.getObject();
                } else {
                    this.zOne[0] = value.getDouble();
                    this.z = this.zOne;
                }
                this.isSet = true;
                break;
            }
            case 0: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n2 = Math.min(this.elementSet.getNumberOfElements(), nArray.length);
                    for (int i = 0; i < n2; ++i) {
                        ((InteractiveTrace)this.elementSet.elementAt(i)).setMaximumPoints(nArray[i]);
                    }
                } else {
                    int n3 = value.getInteger();
                    int n4 = this.elementSet.getNumberOfElements();
                    for (int i = 0; i < n4; ++i) {
                        ((InteractiveTrace)this.elementSet.elementAt(i)).setMaximumPoints(n3);
                    }
                }
                break;
            }
            case 1: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n5 = Math.min(this.elementSet.getNumberOfElements(), nArray.length);
                    for (int i = 0; i < n5; ++i) {
                        ((InteractiveTrace)this.elementSet.elementAt(i)).setSkip(nArray[i]);
                    }
                } else {
                    int n6 = value.getInteger();
                    int n7 = this.elementSet.getNumberOfElements();
                    for (int i = 0; i < n7; ++i) {
                        ((InteractiveTrace)this.elementSet.elementAt(i)).setSkip(n6);
                    }
                }
                break;
            }
            case 2: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n8 = Math.min(this.elementSet.getNumberOfElements(), blArray.length);
                    for (int i = 0; i < n8; ++i) {
                        ((InteractiveTrace)this.elementSet.elementAt(i)).setActive(blArray[i]);
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n9 = this.elementSet.getNumberOfElements();
                    for (int i = 0; i < n9; ++i) {
                        ((InteractiveTrace)this.elementSet.elementAt(i)).setActive(bl);
                    }
                }
                break;
            }
            case 3: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n10 = Math.min(this.elementSet.getNumberOfElements(), blArray.length);
                    for (int i = 0; i < n10; ++i) {
                        ((InteractiveTrace)this.elementSet.elementAt(i)).setIgnoreEqualPoints(blArray[i]);
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n11 = this.elementSet.getNumberOfElements();
                    for (int i = 0; i < n11; ++i) {
                        ((InteractiveTrace)this.elementSet.elementAt(i)).setIgnoreEqualPoints(bl);
                    }
                }
                break;
            }
            case 4: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n12 = Math.min(this.elementSet.getNumberOfElements(), blArray.length);
                    for (int i = 0; i < n12; ++i) {
                        ((InteractiveTrace)this.elementSet.elementAt(i)).setConnected(blArray[i]);
                    }
                } else {
                    boolean bl = value.getBoolean();
                    int n13 = this.elementSet.getNumberOfElements();
                    for (int i = 0; i < n13; ++i) {
                        ((InteractiveTrace)this.elementSet.elementAt(i)).setConnected(bl);
                    }
                }
                break;
            }
            case 5: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n14 = Math.min(this.elementSet.getNumberOfElements(), nArray.length);
                    for (int i = 0; i < n14; ++i) {
                        ((InteractiveTrace)this.elementSet.elementAt(i)).setShapeSize(nArray[i]);
                    }
                } else {
                    int n15 = value.getInteger();
                    int n16 = this.elementSet.getNumberOfElements();
                    for (int i = 0; i < n16; ++i) {
                        ((InteractiveTrace)this.elementSet.elementAt(i)).setShapeSize(n15);
                    }
                }
                break;
            }
            case 6: {
                super.setValue(4, value);
                break;
            }
            case 7: {
                super.setValue(5, value);
                break;
            }
            case 8: {
                super.setValue(6, value);
                break;
            }
            case 9: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n17 = Math.min(this.elementSet.getNumberOfElements(), nArray.length);
                    for (int i = 0; i < n17; ++i) {
                        ((InteractiveTrace)this.elementSet.elementAt(i)).setMemorySets(nArray[i]);
                    }
                } else {
                    int n18 = value.getInteger();
                    int n19 = this.elementSet.getNumberOfElements();
                    for (int i = 0; i < n19; ++i) {
                        ((InteractiveTrace)this.elementSet.elementAt(i)).setMemorySets(n18);
                    }
                }
                break;
            }
            case 10: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n20 = Math.min(this.elementSet.getNumberOfElements(), nArray.length);
                    for (int i = 0; i < n20; ++i) {
                        ((InteractiveTrace)this.elementSet.elementAt(i)).setMemoryDrivenBy(nArray[i]);
                    }
                } else {
                    int n21 = value.getInteger();
                    int n22 = this.elementSet.getNumberOfElements();
                    for (int i = 0; i < n22; ++i) {
                        ((InteractiveTrace)this.elementSet.elementAt(i)).setMemoryDrivenBy(n21);
                    }
                }
                break;
            }
            case 11: {
                if (value.getObject() instanceof Object[]) {
                    Object[] objectArray = (Object[])value.getObject();
                    int n23 = Math.min(this.elementSet.getNumberOfElements(), objectArray.length);
                    for (int i = 0; i < n23; ++i) {
                        ((InteractiveTrace)this.elementSet.elementAt(i)).setMemoryColor((Color)objectArray[i]);
                    }
                } else {
                    if (!(value.getObject() instanceof Color)) break;
                    Color color = (Color)value.getObject();
                    int n24 = this.elementSet.getNumberOfElements();
                    for (int i = 0; i < n24; ++i) {
                        ((InteractiveTrace)this.elementSet.elementAt(i)).setMemoryColor(color);
                    }
                }
                break;
            }
            case 30: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n25 = Math.min(this.elementSet.getNumberOfElements(), nArray.length);
                    for (int i = 0; i < n25; ++i) {
                        ((InteractiveTrace)this.elementSet.elementAt(i)).setShapeType(nArray[i]);
                    }
                } else {
                    int n26 = value.getInteger();
                    int n27 = this.elementSet.getNumberOfElements();
                    for (int i = 0; i < n27; ++i) {
                        ((InteractiveTrace)this.elementSet.elementAt(i)).setShapeType(n26);
                    }
                }
                break;
            }
            default: {
                super.setValue(n - 12, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 16: {
                this.xOne[0] = 0.0;
                this.x = this.xOne;
                break;
            }
            case 17: {
                this.yOne[0] = 0.0;
                this.y = this.yOne;
                break;
            }
            case 18: {
                this.zOne[0] = 0.0;
                this.z = this.zOne;
                break;
            }
            case 0: {
                int n2 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n2; ++i) {
                    ((InteractiveTrace)this.elementSet.elementAt(i)).setMaximumPoints(0);
                }
                break;
            }
            case 1: {
                int n3 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n3; ++i) {
                    ((InteractiveTrace)this.elementSet.elementAt(i)).setSkip(0);
                }
                break;
            }
            case 2: {
                int n4 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n4; ++i) {
                    ((InteractiveTrace)this.elementSet.elementAt(i)).setActive(true);
                }
                break;
            }
            case 3: {
                int n5 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n5; ++i) {
                    ((InteractiveTrace)this.elementSet.elementAt(i)).setIgnoreEqualPoints(false);
                }
                break;
            }
            case 4: {
                int n6 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n6; ++i) {
                    ((InteractiveTrace)this.elementSet.elementAt(i)).setConnected(true);
                }
                break;
            }
            case 5: {
                int n7 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n7; ++i) {
                    ((InteractiveTrace)this.elementSet.elementAt(i)).setShapeSize(5);
                }
                break;
            }
            case 6: {
                super.setDefaultValue(4);
                break;
            }
            case 7: {
                super.setDefaultValue(5);
                break;
            }
            case 8: {
                super.setDefaultValue(6);
                break;
            }
            case 9: {
                int n8 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n8; ++i) {
                    ((InteractiveTrace)this.elementSet.elementAt(i)).setMemorySets(1);
                }
                break;
            }
            case 10: {
                int n9 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n9; ++i) {
                    ((InteractiveTrace)this.elementSet.elementAt(i)).setMemoryDrivenBy(0);
                }
                break;
            }
            case 11: {
                int n10 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n10; ++i) {
                    InteractiveElement interactiveElement = this.elementSet.elementAt(i);
                    ((InteractiveTrace)interactiveElement).setMemoryColor(Color.BLACK);
                }
                break;
            }
            case 30: {
                int n11 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n11; ++i) {
                    ((InteractiveTrace)this.elementSet.elementAt(i)).setShapeType(0);
                }
                break;
            }
            default: {
                super.setDefaultValue(n - 12);
            }
        }
    }

    public String getDefaultValueString(int n) {
        switch (n) {
            case 16: 
            case 17: 
            case 18: {
                return "0";
            }
            case 0: 
            case 1: {
                return "0";
            }
            case 2: {
                return "true";
            }
            case 3: {
                return "false";
            }
            case 4: {
                return "true";
            }
            case 5: {
                return "5";
            }
            case 6: {
                return super.getDefaultValueString(4);
            }
            case 7: {
                return super.getDefaultValueString(5);
            }
            case 8: {
                return super.getDefaultValueString(6);
            }
            case 9: {
                return "1";
            }
            case 10: {
                return "SHOW_ALL";
            }
            case 11: {
                return "BLACK";
            }
            case 30: {
                return "NONE";
            }
        }
        return super.getDefaultValueString(n - 12);
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 9: 
            case 10: 
            case 11: 
            case 16: 
            case 17: 
            case 18: {
                return null;
            }
            case 6: {
                return super.getValue(4);
            }
            case 7: {
                return super.getValue(5);
            }
            case 8: {
                return super.getValue(6);
            }
        }
        return super.getValue(n - 12);
    }

    int[] getPosSpot() {
        return posSpot;
    }

    int[] getSizeSpot() {
        return sizeSpot;
    }
}

