/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.displayejs;

import java.util.ArrayList;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.InteractiveSpring;
import org.opensourcephysics.ejs.control.displayejs.ControlInteractiveElement;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlSpring
extends ControlInteractiveElement {
    private static final int SPRING_ADDED = 3;
    private static final int MY_ENABLED = 10;
    private static final int MY_ENABLED_SECONDARY = 11;
    private static final int[] posSpot = new int[]{3, 4, 5};
    private static final int[] sizeSpot = new int[]{6, 7, 8};
    static ArrayList infoList = null;

    public ControlSpring(Object object) {
        super(object);
        this.enabledEjsEdit = true;
    }

    protected Drawable createDrawable(Object object) {
        if (object instanceof InteractiveSpring) {
            return (InteractiveSpring)object;
        }
        InteractiveSpring interactiveSpring = new InteractiveSpring();
        interactiveSpring.setEnabled(1, true);
        return interactiveSpring;
    }

    int[] getPosSpot() {
        return posSpot;
    }

    int[] getSizeSpot() {
        return sizeSpot;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("radius");
            infoList.add("solenoid");
            infoList.add("thinExtremes");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyCommonName(String string) {
        if (string.equals("color")) {
            return "lineColor";
        }
        if (string.equals("secondaryColor")) {
            return "fillColor";
        }
        if (string.equals("enabled")) {
            return "enabledSize";
        }
        if (string.equals("enabledSecondary")) {
            return "enabledPosition";
        }
        return super.getPropertyCommonName(string);
    }

    public String getPropertyInfo(String string) {
        if (string.equals("radius")) {
            return "int|double";
        }
        if (string.equals("solenoid")) {
            return "int|double";
        }
        if (string.equals("thinExtremes")) {
            return "boolean";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                ((InteractiveSpring)this.myElement).setRadius(value.getDouble());
                break;
            }
            case 1: {
                ((InteractiveSpring)this.myElement).setSolenoid(value.getDouble());
                break;
            }
            case 2: {
                ((InteractiveSpring)this.myElement).setThinExtremes(value.getBoolean());
                break;
            }
            case 10: {
                this.myElement.setEnabled(1, value.getBoolean());
                break;
            }
            case 11: {
                this.myElement.setEnabled(0, value.getBoolean());
                break;
            }
            default: {
                super.setValue(n - 3, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                ((InteractiveSpring)this.myElement).setRadius(0.1);
                break;
            }
            case 1: {
                ((InteractiveSpring)this.myElement).setSolenoid(0.0);
                break;
            }
            case 2: {
                ((InteractiveSpring)this.myElement).setThinExtremes(true);
                break;
            }
            case 10: {
                this.myElement.setEnabled(1, true);
                break;
            }
            case 11: {
                this.myElement.setEnabled(0, false);
                break;
            }
            default: {
                super.setDefaultValue(n - 3);
            }
        }
    }

    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "0.1";
            }
            case 1: {
                return "0";
            }
            case 2: {
                return "true";
            }
            case 10: {
                return "true";
            }
            case 11: {
                return "false";
            }
        }
        return super.getDefaultValueString(n - 3);
    }
}

