/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.displayejs;

import java.awt.Color;
import java.awt.Paint;
import java.util.ArrayList;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.ElementSet;
import org.opensourcephysics.displayejs.InteractiveParticle;
import org.opensourcephysics.ejs.control.displayejs.ControlElementSet;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlParticleSet
extends ControlElementSet {
    private static final int PARTICLE_SET_ADDED = 1;
    private static final int MY_STYLE = 19;
    private static final int MY_PRIMARY_COLOR = 23;
    private static final int MY_SECONDARY_COLOR = 24;
    private static final int[] posSpot = new int[]{5, 6, 7};
    private static final int[] sizeSpot = new int[]{8, 9, 10};
    private static ArrayList infoList = null;

    public ControlParticleSet(Object object) {
        super(object);
    }

    protected Drawable createDrawable(Object object) {
        if (object instanceof ElementSet) {
            this.elementSet = (ElementSet)object;
        } else {
            this.elementSet = new ElementSet(1, InteractiveParticle.class);
            this.elementSet.setEnabled(0, true);
        }
        return this.elementSet;
    }

    int[] getPosSpot() {
        return posSpot;
    }

    int[] getSizeSpot() {
        return sizeSpot;
    }

    int getElementSpot() {
        return 32;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("pixelSize");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("pixelSize")) {
            return "boolean|boolean[]";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                if (value.getObject() instanceof boolean[]) {
                    boolean[] blArray = (boolean[])value.getObject();
                    int n2 = this.elementSet.getNumberOfElements();
                    for (int i = 0; i < n2; ++i) {
                        ((InteractiveParticle)this.elementSet.elementAt(i)).setPixelSize(blArray[i]);
                    }
                } else {
                    int n3 = this.elementSet.getNumberOfElements();
                    for (int i = 0; i < n3; ++i) {
                        ((InteractiveParticle)this.elementSet.elementAt(i)).setPixelSize(value.getBoolean());
                    }
                }
                break;
            }
            case 19: {
                if (value.getObject() instanceof int[]) {
                    int[] nArray = (int[])value.getObject();
                    int n4 = Math.min(this.elementSet.getNumberOfElements(), nArray.length);
                    for (int i = 0; i < n4; ++i) {
                        ((InteractiveParticle)this.elementSet.elementAt(i)).setShapeType(nArray[i]);
                    }
                } else {
                    int n5 = value.getInteger();
                    int n6 = this.elementSet.getNumberOfElements();
                    for (int i = 0; i < n6; ++i) {
                        ((InteractiveParticle)this.elementSet.elementAt(i)).setShapeType(n5);
                    }
                }
                break;
            }
            case 23: {
                if (value.getObject() instanceof Object[]) {
                    Object[] objectArray = (Object[])value.getObject();
                    int n7 = Math.min(this.elementSet.getNumberOfElements(), objectArray.length);
                    for (int i = 0; i < n7; ++i) {
                        this.elementSet.elementAt(i).getStyle().setFillPattern((Paint)objectArray[i]);
                    }
                } else {
                    if (!(value.getObject() instanceof Color)) break;
                    Paint paint = (Paint)value.getObject();
                    if (paint == NULL_COLOR) {
                        paint = null;
                    }
                    int n8 = this.elementSet.getNumberOfElements();
                    for (int i = 0; i < n8; ++i) {
                        this.elementSet.elementAt(i).getStyle().setFillPattern(paint);
                    }
                }
                break;
            }
            case 24: {
                if (value.getObject() instanceof Object[]) {
                    Object[] objectArray = (Object[])value.getObject();
                    int n9 = Math.min(this.elementSet.getNumberOfElements(), objectArray.length);
                    for (int i = 0; i < n9; ++i) {
                        this.elementSet.elementAt(i).getStyle().setEdgeColor((Color)objectArray[i]);
                    }
                } else {
                    if (!(value.getObject() instanceof Color)) break;
                    Color color = (Color)value.getObject();
                    int n10 = this.elementSet.getNumberOfElements();
                    for (int i = 0; i < n10; ++i) {
                        this.elementSet.elementAt(i).getStyle().setEdgeColor(color);
                    }
                }
                break;
            }
            default: {
                super.setValue(n - 1, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                int n2 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n2; ++i) {
                    ((InteractiveParticle)this.elementSet.elementAt(i)).setPixelSize(false);
                }
                break;
            }
            case 19: {
                int n3 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n3; ++i) {
                    ((InteractiveParticle)this.elementSet.elementAt(i)).setShapeType(1);
                }
                break;
            }
            case 23: {
                int n4 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n4; ++i) {
                    this.elementSet.elementAt(i).getStyle().setFillPattern(Color.blue);
                }
                break;
            }
            case 24: {
                int n5 = this.elementSet.getNumberOfElements();
                for (int i = 0; i < n5; ++i) {
                    this.elementSet.elementAt(i).getStyle().setEdgeColor(Color.black);
                }
                break;
            }
            default: {
                super.setDefaultValue(n - 1);
            }
        }
    }

    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "false";
            }
            default: {
                return super.getDefaultValueString(n - 1);
            }
            case 19: {
                return "ELLIPSE";
            }
            case 23: {
                return "BLUE";
            }
            case 24: 
        }
        return "BLACK";
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: {
                return null;
            }
        }
        return super.getValue(n - 1);
    }
}

