/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.displayejs;

import java.awt.Paint;
import java.util.ArrayList;
import org.opensourcephysics.displayejs.AbstractInteractiveTile;
import org.opensourcephysics.ejs.control.displayejs.ControlInteractiveElement;
import org.opensourcephysics.ejs.control.value.Value;

public abstract class ControlInteractiveTile
extends ControlInteractiveElement {
    public static final int PROPERTIES_ADDED = 7;
    protected double[] colorLevels = null;
    protected Paint[] colorFills = null;
    protected double[] colorOrigin = new double[]{0.0, 0.0, 0.0};
    protected double[] colorDirection = new double[]{1.0, 0.0, 0.0};
    static ArrayList infoList = null;

    public ControlInteractiveTile(Object object) {
        super(object);
        this.enabledEjsEdit = true;
    }

    public ArrayList getPropertyList() {
        if (infoList == null) {
            infoList = new ArrayList();
            infoList.add("displacementFactor");
            infoList.add("colorOrigin");
            infoList.add("colorDirection");
            infoList.add("colorLevels");
            infoList.add("colorFills");
            infoList.add("belowWhenEqual");
            infoList.add("interiorTransparency");
            infoList.addAll(super.getPropertyList());
        }
        return infoList;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("displacementFactor")) {
            return "int|double";
        }
        if (string.equals("colorOrigin")) {
            return "double[]";
        }
        if (string.equals("colorDirection")) {
            return "double[]";
        }
        if (string.equals("colorLevels")) {
            return "double[]";
        }
        if (string.equals("colorFills")) {
            return "Object[]";
        }
        if (string.equals("belowWhenEqual")) {
            return "boolean";
        }
        if (string.equals("interiorTransparency")) {
            return "int";
        }
        return super.getPropertyInfo(string);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 0: {
                ((AbstractInteractiveTile)this.myElement).setDisplacementFactor(value.getDouble());
                break;
            }
            case 1: {
                double[] dArray;
                if (!(value.getObject() instanceof double[]) || (dArray = (double[])value.getObject()).length <= 2) break;
                this.colorOrigin[0] = dArray[0];
                this.colorOrigin[1] = dArray[1];
                this.colorOrigin[2] = dArray[2];
                ((AbstractInteractiveTile)this.myElement).setColorOriginAndDirection(this.colorOrigin[0], this.colorOrigin[1], this.colorOrigin[2], this.colorDirection[0], this.colorDirection[1], this.colorDirection[2]);
                break;
            }
            case 2: {
                double[] dArray;
                if (!(value.getObject() instanceof double[]) || (dArray = (double[])value.getObject()).length <= 2) break;
                this.colorDirection[0] = dArray[0];
                this.colorDirection[1] = dArray[1];
                this.colorDirection[2] = dArray[2];
                ((AbstractInteractiveTile)this.myElement).setColorOriginAndDirection(this.colorOrigin[0], this.colorOrigin[1], this.colorOrigin[2], this.colorDirection[0], this.colorDirection[1], this.colorDirection[2]);
                break;
            }
            case 3: {
                if (!(value.getObject() instanceof double[])) break;
                this.colorLevels = (double[])value.getObject();
                if (this.colorFills == null || this.colorFills.length != this.colorLevels.length + 1) break;
                ((AbstractInteractiveTile)this.myElement).setColorRegions(this.colorLevels, this.colorFills);
                break;
            }
            case 4: {
                if (!(value.getObject() instanceof Object[])) break;
                Object[] objectArray = (Object[])value.getObject();
                this.colorFills = new Paint[objectArray.length];
                for (int i = 0; i < objectArray.length; ++i) {
                    this.colorFills[i] = (Paint)objectArray[i];
                }
                if (this.colorLevels == null || this.colorLevels.length != this.colorFills.length - 1) break;
                ((AbstractInteractiveTile)this.myElement).setColorRegions(this.colorLevels, this.colorFills);
                break;
            }
            case 5: {
                ((AbstractInteractiveTile)this.myElement).setColorBelowWhenEqual(value.getBoolean());
                break;
            }
            case 6: {
                this.quickInterior(value.getInteger());
                break;
            }
            default: {
                super.setValue(n - 7, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 0: {
                ((AbstractInteractiveTile)this.myElement).setDisplacementFactor(1.0);
                break;
            }
            case 1: {
                this.colorOrigin = new double[]{0.0, 0.0, 0.0};
                ((AbstractInteractiveTile)this.myElement).setColorOriginAndDirection(this.colorOrigin[0], this.colorOrigin[1], this.colorOrigin[2], this.colorDirection[0], this.colorDirection[1], this.colorDirection[2]);
                break;
            }
            case 2: {
                this.colorDirection = new double[]{1.0, 0.0, 0.0};
                ((AbstractInteractiveTile)this.myElement).setColorOriginAndDirection(this.colorOrigin[0], this.colorOrigin[1], this.colorOrigin[2], this.colorDirection[0], this.colorDirection[1], this.colorDirection[2]);
                break;
            }
            case 3: {
                this.colorLevels = null;
                ((AbstractInteractiveTile)this.myElement).setColorRegions(null, null);
                break;
            }
            case 4: {
                this.colorFills = null;
                ((AbstractInteractiveTile)this.myElement).setColorRegions(null, null);
                break;
            }
            case 5: {
                ((AbstractInteractiveTile)this.myElement).setColorBelowWhenEqual(true);
                break;
            }
            case 6: {
                this.quickInterior(-1);
                break;
            }
            default: {
                super.setDefaultValue(n - 7);
            }
        }
    }

    public String getDefaultValueString(int n) {
        switch (n) {
            case 0: {
                return "1";
            }
            case 1: {
                return "{0.0,0.0,0.0}";
            }
            case 2: {
                return "{1.0,0.0,0.0}";
            }
            case 3: 
            case 4: {
                return "<none>";
            }
            case 5: {
                return "true";
            }
            case 6: {
                return "-1";
            }
        }
        return super.getDefaultValueString(n - 7);
    }

    public Value getValue(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return null;
            }
        }
        return this.getValue(n - 7);
    }

    protected void quickInterior(int n) {
        if (n < 0 || n > 255) {
            ((AbstractInteractiveTile)this.myElement).setDrawQuickInterior(false, 0);
        } else {
            ((AbstractInteractiveTile)this.myElement).setDrawQuickInterior(true, n);
        }
    }
}

