/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs.control.displayejs;

import java.awt.Color;
import org.opensourcephysics.display.Drawable;
import org.opensourcephysics.displayejs.InteractiveCursor;
import org.opensourcephysics.ejs.control.displayejs.ControlInteractiveElement;
import org.opensourcephysics.ejs.control.value.IntegerValue;
import org.opensourcephysics.ejs.control.value.Value;

public class ControlCursor
extends ControlInteractiveElement {
    private static final int CURSOR_ADDED = 0;
    private static final int MY_STYLE = 14;
    private static final int MY_SECONDARY_COLOR = 19;
    private static final int[] posSpot = new int[]{0, 1, 2};
    private static final int[] sizeSpot = new int[]{3, 4, 5};

    public ControlCursor(Object object) {
        super(object);
        this.enabledEjsEdit = true;
    }

    protected Drawable createDrawable(Object object) {
        if (object instanceof InteractiveCursor) {
            return (InteractiveCursor)object;
        }
        InteractiveCursor interactiveCursor = new InteractiveCursor();
        interactiveCursor.setEnabled(0, true);
        return interactiveCursor;
    }

    int[] getPosSpot() {
        return posSpot;
    }

    int[] getSizeSpot() {
        return sizeSpot;
    }

    public String getPropertyInfo(String string) {
        if (string.equals("style")) {
            return "CursorShape|int";
        }
        return super.getPropertyInfo(string);
    }

    public Value parseConstant(String string, String string2) {
        if (string2 == null) {
            return null;
        }
        if (string.indexOf("CursorShape") >= 0) {
            if ((string2 = string2.trim().toLowerCase()).equals("crosshair")) {
                return new IntegerValue(2);
            }
            if (string2.equals("horizontal")) {
                return new IntegerValue(0);
            }
            if (string2.equals("vertical")) {
                return new IntegerValue(1);
            }
        }
        return super.parseConstant(string, string2);
    }

    public void setValue(int n, Value value) {
        switch (n) {
            case 14: {
                ((InteractiveCursor)this.myElement).setType(value.getInteger());
                break;
            }
            case 19: {
                this.myElement.getStyle().setEdgeColor((Color)value.getObject());
                break;
            }
            default: {
                super.setValue(n - 0, value);
            }
        }
    }

    public void setDefaultValue(int n) {
        switch (n) {
            case 14: {
                ((InteractiveCursor)this.myElement).setType(2);
                break;
            }
            case 19: {
                this.myElement.getStyle().setEdgeColor(Color.black);
                break;
            }
            default: {
                super.setDefaultValue(n - 0);
            }
        }
    }

    public String getDefaultValueString(int n) {
        switch (n) {
            case 14: {
                return "CROSSHAIR";
            }
            case 19: {
                return "BLACK";
            }
        }
        return super.getDefaultValueString(n - 0);
    }

    public Value getValue(int n) {
        switch (n) {
            default: 
        }
        return super.getValue(n - 0);
    }
}

