/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.ejs;

import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.io.PrintWriter;
import java.net.URL;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.swing.JOptionPane;
import org.colos.ejs.external.ExternalApp;
import org.colos.ejs.external.ExternalAppsHandler;
import org.colos.ejs.external.ExternalClient;
import org.opensourcephysics.ejs.Input;
import org.opensourcephysics.ejs.LauncherApplet;
import org.opensourcephysics.ejs.Memory;
import org.opensourcephysics.ejs.Model;
import org.opensourcephysics.ejs.Simulation;
import org.opensourcephysics.ejs.View;
import org.opensourcephysics.ejs.utils.HardcopyWriter;

public abstract class AbstractModel
implements Model,
ExternalClient {
    protected String[] __theArguments = null;
    protected LauncherApplet __theApplet = null;
    protected ExternalAppsHandler _external = new ExternalAppsHandler(this);
    public Memory _memory = new Memory();
    protected Input _input = new Input();
    protected ArrayList _scheduledConditionsList = new ArrayList();
    protected Hashtable _scheduledEventsList = new Hashtable();
    private _ControlSimulationExperimentClass _cSE = new _ControlSimulationExperimentClass();

    public abstract View getView();

    public abstract Simulation getSimulation();

    public LauncherApplet _getApplet() {
        return this.__theApplet;
    }

    public void _play() {
        this.getSimulation().play();
    }

    public void _playAndWait() {
        this._play();
        this._cSE._controlForSimulation();
    }

    public void _pause() {
        this.getSimulation().pause();
        this._cSE._controlForExperiment();
    }

    public void _step() {
        this._pause();
        this.getSimulation().step();
    }

    public void _setFPS(int n) {
        this.getSimulation().setFPS(n);
    }

    public void _setDelay(int n) {
        this.getSimulation().setDelay(n);
    }

    public int _getDelay() {
        if (this.getSimulation() != null) {
            return this.getSimulation().getDelay();
        }
        return 0;
    }

    public void _setStepsPerDisplay(int n) {
        this.getSimulation().setStepsPerDisplay(n);
    }

    public void _setUpdateView(boolean bl) {
        this.getSimulation().setUpdateView(bl);
    }

    public void _reset() {
        this._external.reset();
        this.getSimulation().reset();
    }

    public void _initialize() {
        this._external.reset();
        this.getSimulation().initialize();
    }

    public void _alert(String string, String string2, String string3) {
        if (this.getView() != null) {
            JOptionPane.showMessageDialog(this.getView().getComponent(string), string3, string2, 1);
        } else {
            JOptionPane.showMessageDialog(this.getSimulation().getParentComponent(), string3, string2, 1);
        }
    }

    public void _print(String string) {
        if (this.getView() != null) {
            this.getView().print(string);
        } else {
            System.out.print(string);
        }
    }

    public void _println(String string) {
        if (this.getView() != null) {
            this.getView().println(string);
        } else {
            System.out.print(string);
        }
    }

    public void _println() {
        if (this.getView() != null) {
            this.getView().println();
        } else {
            System.out.println();
        }
    }

    public void _clearMessages() {
        if (this.getView() != null) {
            this.getView().clearMessages();
        }
    }

    public String _format(double d, String string) {
        DecimalFormat decimalFormat = new DecimalFormat(string);
        return decimalFormat.format(d);
    }

    public String _getParameter(String string) {
        if (this.__theApplet != null) {
            return this.__theApplet.getParameter(string);
        }
        if (this.__theArguments == null) {
            return null;
        }
        for (int i = 0; i < this.__theArguments.length; ++i) {
            if (!this.__theArguments[i].equals("-" + string) || i + 1 >= this.__theArguments.length) continue;
            return this.__theArguments[i + 1];
        }
        return null;
    }

    public String[] _getArguments() {
        return this.__theArguments;
    }

    public boolean _isPlaying() {
        return this.getSimulation().isPlaying();
    }

    public boolean _isPaused() {
        return this.getSimulation().isPaused();
    }

    public boolean _isApplet() {
        return this.__theApplet != null;
    }

    public void _printerJob(String string, String string2, int n) {
        this._printerJob(string, string2, n, 0.5, 0.5, 0.5, 0.5);
    }

    public void _printerJob(String string, String string2, int n, double d, double d2, double d3, double d4) {
        Frame frame = new Frame("Printing " + string);
        frame.setSize(200, 50);
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        frame.setLocation((dimension.width - frame.getSize().width) / 2, (dimension.height - frame.getSize().height) / 2);
        frame.setVisible(true);
        try {
            HardcopyWriter hardcopyWriter = new HardcopyWriter(frame, string, n, d2, d4, d, d3);
            PrintWriter printWriter = new PrintWriter(hardcopyWriter);
            printWriter.println(string2);
            printWriter.close();
        }
        catch (HardcopyWriter.PrintCanceledException printCanceledException) {
            // empty catch block
        }
        frame.setVisible(false);
        frame.dispose();
    }

    public void _setParentComponent(String string) {
        this.getSimulation().setParentComponent(string);
    }

    public boolean _saveImage(String string, String string2) {
        return this.getSimulation().saveImage(string, string2);
    }

    public boolean _saveState(String string) {
        return this.getSimulation().saveState(string);
    }

    public boolean _saveVariables(String string, String string2) {
        return this.getSimulation().saveVariables(string, string2);
    }

    public boolean _saveVariables(String string, ArrayList arrayList) {
        return this.getSimulation().saveVariables(string, arrayList);
    }

    public boolean _saveText(String string, String string2) {
        return this.getSimulation().saveText(string, string2);
    }

    public boolean _saveText(String string, StringBuffer stringBuffer) {
        return this.getSimulation().saveText(string, stringBuffer);
    }

    public boolean _readState(String string) {
        return this.getSimulation().readState(string);
    }

    public boolean _readVariables(String string, String string2) {
        return this.getSimulation().readVariables(string, (URL)null, string2);
    }

    public boolean _readVariables(String string, ArrayList arrayList) {
        return this.getSimulation().readVariables(string, (URL)null, arrayList);
    }

    public String _readText(String string) {
        return this.getSimulation().readText(string);
    }

    public boolean _setVariables(String string, String string2, String string3) {
        return this.getSimulation().setVariables(string, string2, string3);
    }

    public boolean _setVariables(String string) {
        return this.getSimulation().setVariables(string);
    }

    public String _getVariables(String string) {
        return this.getSimulation().getVariable(string);
    }

    public void _clearView() {
        if (this.getView() != null) {
            this.getView().initialize();
        }
    }

    public void _resetView() {
        if (this.getView() != null) {
            this.getView().reset();
            this.getView().initialize();
        }
    }

    public void _onExit() {
        this.getSimulation().onExit();
        this._external.quit();
    }

    public abstract void _resetSolvers();

    public void _resetIC() {
        this._resetSolvers();
    }

    public abstract String _externalInitCommand(String var1);

    public abstract void _externalSetValues(boolean var1, ExternalApp var2);

    public abstract void _externalGetValues(boolean var1, ExternalApp var2);

    public synchronized void _externalGetValuesAndUpdate(boolean bl, ExternalApp externalApp) {
        this._externalGetValues(bl, externalApp);
        this.getSimulation().update();
    }

    private class _ControlSimulationExperimentClass {
        private _ControlSimulationExperimentClass() {
        }

        public synchronized void _controlForSimulation() {
            try {
                this.wait();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public synchronized void _controlForExperiment() {
            this.notify();
        }
    }
}

