/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs.utils;

import org.opensourcephysics.displayejs.Point3D;

public class VectorAlgebra {
    public static double norm(Point3D point3D) {
        return Math.sqrt(point3D.x * point3D.x + point3D.y * point3D.y + point3D.z * point3D.z);
    }

    public static Point3D crossProduct(Point3D point3D, Point3D point3D2) {
        return new Point3D(point3D.y * point3D2.z - point3D.z * point3D2.y, point3D.z * point3D2.x - point3D.x * point3D2.z, point3D.x * point3D2.y - point3D.y * point3D2.x);
    }

    public static Point3D normalize(Point3D point3D) {
        double d = VectorAlgebra.norm(point3D);
        return new Point3D(point3D.x / d, point3D.y / d, point3D.z / d);
    }

    public static Point3D normalTo(Point3D point3D) {
        if (point3D.x == 0.0) {
            return new Point3D(1.0, 0.0, 0.0);
        }
        if (point3D.y == 0.0) {
            return new Point3D(0.0, 1.0, 0.0);
        }
        if (point3D.z == 0.0) {
            return new Point3D(0.0, 0.0, 1.0);
        }
        double d = Math.sqrt(point3D.x * point3D.x + point3D.y * point3D.y);
        return new Point3D(-point3D.y / d, point3D.x / d, 0.0);
    }
}

