/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.AbstractInteractiveTile;
import org.opensourcephysics.displayejs.InteractionTargetElementPosition;
import org.opensourcephysics.displayejs.InteractiveElement;

public class InteractiveSurface
extends AbstractInteractiveTile {
    protected double[][][] data;
    protected int nu = -1;
    protected int nv = -1;
    protected double[] center = new double[]{0.0, 0.0, 0.0};
    protected double[] size = new double[]{1.0, 1.0, 1.0};

    public InteractiveSurface() {
        this.setXYZ(0.0, 0.0, 0.0);
        this.setSizeXYZ(1.0, 1.0, 1.0);
    }

    public void copyFrom(InteractiveElement interactiveElement) {
        super.copyFrom(interactiveElement);
        if (interactiveElement instanceof InteractiveSurface) {
            this.setData(((InteractiveSurface)interactiveElement).data);
        }
    }

    public void setData(double[][][] dArray) {
        this.data = dArray;
        this.hasChanged = true;
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!this.visible) {
            return null;
        }
        if (this.hasChanged) {
            this.computeCorners();
            this.projectPoints(drawingPanel);
        } else if (drawingPanel != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel);
        }
        if (this.positionEnabled && Math.abs(this.pixelOrigin[0] - (double)n) < (double)SENSIBILITY && Math.abs(this.pixelOrigin[1] - (double)n2) < (double)SENSIBILITY) {
            return new InteractionTargetElementPosition(this);
        }
        return null;
    }

    protected void projectPoints(DrawingPanel drawingPanel) {
        super.projectPoints(drawingPanel);
        if (this.corners == null) {
            return;
        }
        if (this.group == null) {
            drawingPanel.project(this.corners[0][0], this.pixelOrigin);
        } else {
            this.coordinates[0] = this.group.x + this.corners[0][0][0] * this.group.sizex;
            this.coordinates[1] = this.group.y + this.corners[0][0][1] * this.group.sizey;
            this.coordinates[2] = this.group.z + this.corners[0][0][2] * this.group.sizez;
            drawingPanel.project(this.coordinates, this.pixelOrigin);
        }
    }

    protected synchronized void computeCorners() {
        if (this.data == null) {
            return;
        }
        int n = this.data.length - 1;
        int n2 = this.data[0].length - 1;
        if (this.nu != n || this.nv != n2) {
            this.nu = n;
            this.nv = n2;
            this.setCorners(new double[this.nu * this.nv][4][3]);
        }
        int n3 = 0;
        this.center[0] = this.x;
        this.center[1] = this.y;
        this.center[2] = this.z;
        this.size[0] = this.sizex;
        this.size[1] = this.sizey;
        this.size[2] = this.sizez;
        for (int i = 0; i < this.nv; ++i) {
            int n4 = 0;
            while (n4 < this.nu) {
                for (int j = 0; j < 3; ++j) {
                    this.corners[n3][0][j] = this.center[j] + this.data[n4][i][j] * this.size[j];
                    this.corners[n3][1][j] = this.center[j] + this.data[n4 + 1][i][j] * this.size[j];
                    this.corners[n3][2][j] = this.center[j] + this.data[n4 + 1][i + 1][j] * this.size[j];
                    this.corners[n3][3][j] = this.center[j] + this.data[n4][i + 1][j] * this.size[j];
                }
                ++n4;
                ++n3;
            }
        }
        this.transformCorners();
        this.zmax = Double.NaN;
        this.zmin = Double.NaN;
        this.ymax = Double.NaN;
        this.ymin = Double.NaN;
        this.xmax = Double.NaN;
        this.xmin = Double.NaN;
        this.hasChanged = false;
    }
}

