/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.AbstractInteractiveElement;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Object3D;

public class InteractivePoints
extends AbstractInteractiveElement {
    protected int numPoints = -1;
    protected double[][] coordinates = null;
    protected int[] aPoints = null;
    protected int[] bPoints = null;
    protected double[] pixel = new double[3];
    protected double[] point = new double[3];
    protected Object3D[] pointObjects = null;

    public InteractivePoints() {
        this.setXYZ(0.0, 0.0, 0.0);
        this.setSizeXYZ(1.0, 1.0, 1.0);
    }

    public void copyFrom(InteractiveElement interactiveElement) {
        super.copyFrom(interactiveElement);
        if (interactiveElement instanceof InteractivePoints) {
            InteractivePoints interactivePoints = (InteractivePoints)interactiveElement;
            this.setNumberOfPoints(interactivePoints.getNumberOfPoints());
            this.setData(interactivePoints.getData());
        }
    }

    protected void setNumberOfPoints(int n) {
        if (n == this.numPoints) {
            return;
        }
        if (n < 1) {
            return;
        }
        this.numPoints = n;
        this.coordinates = new double[this.numPoints][3];
        this.aPoints = new int[this.numPoints];
        this.bPoints = new int[this.numPoints];
        this.pointObjects = new Object3D[this.numPoints];
        for (int i = 0; i < this.numPoints; ++i) {
            this.coordinates[i][2] = 0.0;
            this.coordinates[i][1] = 0.0;
            this.coordinates[i][0] = 0.0;
            this.pointObjects[i] = new Object3D(this, i);
        }
        this.hasChanged = true;
    }

    public int getNumberOfPoints() {
        return this.numPoints;
    }

    public void setData(double[][] dArray) {
        if (dArray == null) {
            this.numPoints = -1;
            this.coordinates = null;
            return;
        }
        if (this.numPoints != dArray.length) {
            this.setNumberOfPoints(dArray.length);
        }
        int n = Math.max(dArray.length, this.numPoints);
        int n2 = Math.min(dArray[0].length, 3);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                this.coordinates[i][j] = dArray[i][j];
            }
        }
        this.hasChanged = true;
    }

    public double[][] getData() {
        return this.coordinates;
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        return null;
    }

    public Object3D[] getObjects3D(DrawingPanel3D drawingPanel3D) {
        if (this.numPoints <= 0 || !this.visible) {
            return null;
        }
        if (this.hasChanged || drawingPanel3D != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel3D);
        }
        return this.pointObjects;
    }

    public void draw(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D, int n) {
        if (this.style.edgeColor != null) {
            Color color = drawingPanel3D.projectColor(this.style.edgeColor, this.pointObjects[n].distance);
            graphics2D.setStroke(this.style.edgeStroke);
            graphics2D.setColor(color);
            graphics2D.drawLine(this.aPoints[n], this.bPoints[n], this.aPoints[n], this.bPoints[n]);
        }
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (this.numPoints <= 0 || !this.visible) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        this.projectPoints(drawingPanel);
        if (this.style.edgeColor != null) {
            graphics2D.setColor(this.style.edgeColor);
            graphics2D.setStroke(this.style.edgeStroke);
            for (int i = 0; i < this.numPoints; ++i) {
                graphics2D.drawLine(this.aPoints[i], this.bPoints[i], this.aPoints[i], this.bPoints[i]);
            }
        }
    }

    public boolean isMeasured() {
        return this.canBeMeasured && this.numPoints > 0;
    }

    public double getXMin() {
        if (this.numPoints <= 0) {
            return 0.0;
        }
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.numPoints; ++i) {
            if (!(this.coordinates[i][0] < d)) continue;
            d = this.coordinates[i][0];
        }
        if (this.group == null) {
            return d;
        }
        return this.group.x + d * this.group.sizex;
    }

    public double getXMax() {
        if (this.numPoints <= 0) {
            return 0.0;
        }
        double d = -1.7976931348623157E308;
        for (int i = 0; i < this.numPoints; ++i) {
            if (!(this.coordinates[i][0] > d)) continue;
            d = this.coordinates[i][0];
        }
        if (this.group == null) {
            return d;
        }
        return this.group.x + d * this.group.sizex;
    }

    public double getYMin() {
        if (this.numPoints <= 0) {
            return 0.0;
        }
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.numPoints; ++i) {
            if (!(this.coordinates[i][1] < d)) continue;
            d = this.coordinates[i][1];
        }
        if (this.group == null) {
            return d;
        }
        return this.group.y + d * this.group.sizey;
    }

    public double getYMax() {
        if (this.numPoints <= 0) {
            return 0.0;
        }
        double d = -1.7976931348623157E308;
        for (int i = 0; i < this.numPoints; ++i) {
            if (!(this.coordinates[i][1] > d)) continue;
            d = this.coordinates[i][1];
        }
        if (this.group == null) {
            return d;
        }
        return this.group.y + d * this.group.sizey;
    }

    public double getZMin() {
        if (this.numPoints <= 0) {
            return 0.0;
        }
        double d = Double.MAX_VALUE;
        for (int i = 0; i < this.numPoints; ++i) {
            if (!(this.coordinates[i][2] < d)) continue;
            d = this.coordinates[i][2];
        }
        if (this.group == null) {
            return d;
        }
        return this.group.z + d * this.group.sizez;
    }

    public double getZMax() {
        if (this.numPoints <= 0) {
            return 0.0;
        }
        double d = -1.7976931348623157E308;
        for (int i = 0; i < this.numPoints; ++i) {
            if (!(this.coordinates[i][2] > d)) continue;
            d = this.coordinates[i][2];
        }
        if (this.group == null) {
            return d;
        }
        return this.group.z + d * this.group.sizez;
    }

    protected void projectPoints(DrawingPanel drawingPanel) {
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        if (this.group == null) {
            dArray[0] = this.x;
            dArray[1] = this.y;
            dArray[2] = this.z;
            dArray2[0] = this.sizex;
            dArray2[1] = this.sizey;
            dArray2[2] = this.sizez;
        } else {
            dArray[0] = this.group.x + this.x * this.group.sizex;
            dArray[1] = this.group.y + this.y * this.group.sizey;
            dArray[2] = this.group.z + this.z * this.group.sizez;
            dArray2[0] = this.sizex * this.group.sizex;
            dArray2[1] = this.sizey * this.group.sizey;
            dArray2[2] = this.sizez * this.group.sizez;
        }
        for (int i = 0; i < this.numPoints; ++i) {
            for (int j = 0; j < 3; ++j) {
                double d = this.coordinates[i][j] * dArray2[j];
                this.point[j] = dArray[j] + d;
            }
            drawingPanel.project(this.point, this.pixel);
            this.aPoints[i] = (int)this.pixel[0];
            this.bPoints[i] = (int)this.pixel[1];
            this.pointObjects[i].distance = this.pixel[2];
        }
        this.hasChanged = false;
        this.panelWithValidProjection = drawingPanel;
    }
}

