/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.displayejs;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Paint;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.displayejs.AbstractInteractiveElement;
import org.opensourcephysics.displayejs.Body;
import org.opensourcephysics.displayejs.DrawingPanel3D;
import org.opensourcephysics.displayejs.InteractionTargetElementPosition;
import org.opensourcephysics.displayejs.InteractionTargetElementSize;
import org.opensourcephysics.displayejs.InteractiveElement;
import org.opensourcephysics.displayejs.Object3D;
import org.opensourcephysics.numerics.Transformation;

public abstract class AbstractInteractiveTile
extends AbstractInteractiveElement
implements Body {
    protected boolean drawQuickInterior = false;
    protected int interiorTransparency = 128;
    protected int numberOfTiles = 0;
    protected double[][][] corners = null;
    protected boolean levelBelowWhenEqual = true;
    protected double displacementFactor = 1.0;
    protected double levelx = 0.0;
    protected double levely = 0.0;
    protected double levelz = 0.0;
    protected double leveldx = 0.0;
    protected double leveldy = 0.0;
    protected double leveldz = 1.0;
    protected double[] levelZ = null;
    protected Paint[] levelColors = null;
    protected Transformation transformation = null;
    protected double originx = 0.5;
    protected double originy = 0.5;
    protected double originz = 0.5;
    protected boolean originIsRelative = true;
    protected double xmin = Double.NaN;
    protected double xmax = Double.NaN;
    protected double ymin = Double.NaN;
    protected double ymax = Double.NaN;
    protected double zmin = Double.NaN;
    protected double zmax = Double.NaN;
    protected double[] pixel = new double[3];
    protected double[] coordinates = new double[3];
    protected double[] pixelOrigin = new double[3];
    protected double[] pixelEndpoint = new double[3];
    protected Object3D[] objects = null;
    private double[] center = new double[3];
    private int[][] a = null;
    private int[][] b = null;

    public void copyFrom(InteractiveElement interactiveElement) {
        super.copyFrom(interactiveElement);
        if (interactiveElement instanceof AbstractInteractiveTile) {
            AbstractInteractiveTile abstractInteractiveTile = (AbstractInteractiveTile)interactiveElement;
            this.setOrigin(abstractInteractiveTile.originx, abstractInteractiveTile.originy, abstractInteractiveTile.originz, abstractInteractiveTile.originIsRelative);
            this.setTransformation(abstractInteractiveTile.transformation);
        }
    }

    public void setDisplacementFactor(double d) {
        this.displacementFactor = d;
    }

    public double GetDisplacementFactor() {
        return this.displacementFactor;
    }

    public void setDrawQuickInterior(boolean bl, int n) {
        this.drawQuickInterior = bl;
        this.interiorTransparency = Math.max(0, Math.min(n, 255));
    }

    public void setColorBelowWhenEqual(boolean bl) {
        this.levelBelowWhenEqual = bl;
    }

    public void setColorOriginAndDirection(double d, double d2, double d3, double d4, double d5, double d6) {
        this.levelx = d;
        this.levely = d2;
        this.levelz = d3;
        this.leveldx = d4;
        this.leveldy = d5;
        this.leveldz = d6;
    }

    public void setColorRegions(double[] dArray, Paint[] paintArray) {
        int n;
        if (dArray == null || paintArray == null) {
            this.levelZ = null;
            this.levelColors = null;
            return;
        }
        this.levelZ = new double[dArray.length];
        this.levelColors = new Paint[dArray.length + 1];
        for (n = 0; n < dArray.length; ++n) {
            this.levelZ[n] = dArray[n];
        }
        for (n = 0; n < dArray.length + 1; ++n) {
            this.levelColors[n] = n < paintArray.length ? paintArray[n] : paintArray[paintArray.length - 1];
        }
        this.hasChanged = true;
    }

    public void setOrigin(double d, double d2, double d3, boolean bl) {
        this.originx = d;
        this.originy = d2;
        this.originz = d3;
        this.originIsRelative = bl;
        this.hasChanged = true;
    }

    public void setTransformation(Transformation transformation) {
        this.transformation = (Transformation)transformation.clone();
        this.hasChanged = true;
    }

    public void toSpaceFrame(double[] dArray) {
        if (this.transformation != null) {
            this.transformation.direct(dArray);
        }
        dArray[0] = dArray[0] + this.x;
        dArray[1] = dArray[1] + this.y;
        dArray[2] = dArray[2] + this.z;
    }

    public void toBodyFrame(double[] dArray) throws UnsupportedOperationException {
        dArray[0] = dArray[0] - this.x;
        dArray[1] = dArray[1] - this.y;
        dArray[2] = dArray[2] - this.z;
        if (this.transformation != null) {
            this.transformation.inverse(dArray);
        }
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!this.visible) {
            return null;
        }
        if (this.hasChanged) {
            this.computeCorners();
            this.projectPoints(drawingPanel);
        } else if (drawingPanel != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel);
        }
        if (this.sizeEnabled && Math.abs(this.pixelEndpoint[0] - (double)n) < (double)SENSIBILITY && Math.abs(this.pixelEndpoint[1] - (double)n2) < (double)SENSIBILITY) {
            return new InteractionTargetElementSize(this);
        }
        if (this.positionEnabled && Math.abs(this.pixelOrigin[0] - (double)n) < (double)SENSIBILITY && Math.abs(this.pixelOrigin[1] - (double)n2) < (double)SENSIBILITY) {
            return new InteractionTargetElementPosition(this);
        }
        return null;
    }

    public Object3D[] getObjects3D(DrawingPanel3D drawingPanel3D) {
        if (!this.visible) {
            return null;
        }
        if (this.hasChanged) {
            this.computeCorners();
            this.projectPoints(drawingPanel3D);
        } else if (drawingPanel3D != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel3D);
        }
        if (this.numberOfTiles < 1) {
            return null;
        }
        return this.objects;
    }

    public void draw(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D, int n) {
        Paint paint;
        if (this.levelZ != null) {
            this.drawColorCoded(drawingPanel3D, graphics2D, n);
            return;
        }
        int n2 = this.corners[n].length;
        if (this.style.fillPattern != null) {
            paint = this.style.fillPattern;
            if (paint instanceof Color) {
                paint = drawingPanel3D.projectColor((Color)paint, this.objects[n].distance);
            }
            graphics2D.setPaint(paint);
            graphics2D.fillPolygon(this.a[n], this.b[n], n2);
        }
        if (this.style.edgeColor != null) {
            paint = drawingPanel3D.projectColor(this.style.edgeColor, this.objects[n].distance);
            graphics2D.setColor((Color)paint);
            graphics2D.setStroke(this.style.edgeStroke);
            graphics2D.drawPolygon(this.a[n], this.b[n], n2);
        }
    }

    public void drawQuickly(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D) {
        if (!this.visible) {
            return;
        }
        if (this.hasChanged) {
            this.computeCorners();
            this.projectPoints(drawingPanel3D);
        } else if (drawingPanel3D != this.panelWithValidProjection) {
            this.projectPoints(drawingPanel3D);
        }
        if (this.numberOfTiles < 1) {
            return;
        }
        graphics2D.setStroke(this.style.edgeStroke);
        if (this.drawQuickInterior && this.style.fillPattern instanceof Color) {
            Color color = (Color)this.style.fillPattern;
            if (color.getAlpha() > this.interiorTransparency) {
                color = new Color(color.getRed(), color.getGreen(), color.getBlue(), this.interiorTransparency);
            }
            graphics2D.setPaint(color);
            for (int i = 0; i < this.numberOfTiles; ++i) {
                graphics2D.fillPolygon(this.a[i], this.b[i], this.corners[i].length);
            }
        }
        if (this.style.edgeColor != null) {
            graphics2D.setColor(this.style.edgeColor);
        } else {
            graphics2D.setColor(Color.black);
        }
        for (int i = 0; i < this.numberOfTiles; ++i) {
            graphics2D.drawPolygon(this.a[i], this.b[i], this.corners[i].length);
        }
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        if (!this.visible) {
            return;
        }
        if (this.hasChanged) {
            this.computeCorners();
            this.projectPoints(drawingPanel);
        } else {
            this.projectPoints(drawingPanel);
        }
        if (this.numberOfTiles < 1) {
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setStroke(this.style.edgeStroke);
        for (int i = 0; i < this.numberOfTiles; ++i) {
            int n = this.corners[i].length;
            if (this.style.fillPattern != null) {
                graphics2D.setPaint(this.style.fillPattern);
                graphics2D.fillPolygon(this.a[i], this.b[i], n);
            }
            if (this.style.edgeColor == null) continue;
            graphics2D.setColor(this.style.edgeColor);
            graphics2D.drawPolygon(this.a[i], this.b[i], n);
        }
    }

    public double getXMin() {
        if (this.hasChanged) {
            this.computeCorners();
            this.computeExtrema();
        } else if (Double.isNaN(this.xmin)) {
            this.computeExtrema();
        }
        return this.xmin;
    }

    public double getXMax() {
        if (this.hasChanged) {
            this.computeCorners();
            this.computeExtrema();
        } else if (Double.isNaN(this.xmax)) {
            this.computeExtrema();
        }
        return this.xmax;
    }

    public double getYMin() {
        if (this.hasChanged) {
            this.computeCorners();
            this.computeExtrema();
        } else if (Double.isNaN(this.ymin)) {
            this.computeExtrema();
        }
        return this.ymin;
    }

    public double getYMax() {
        if (this.hasChanged) {
            this.computeCorners();
            this.computeExtrema();
        } else if (Double.isNaN(this.ymax)) {
            this.computeExtrema();
        }
        return this.ymax;
    }

    public double getZMin() {
        if (this.hasChanged) {
            this.computeCorners();
            this.computeExtrema();
        } else if (Double.isNaN(this.zmin)) {
            this.computeExtrema();
        }
        return this.zmin;
    }

    public double getZMax() {
        if (this.hasChanged) {
            this.computeCorners();
            this.computeExtrema();
        } else if (Double.isNaN(this.zmax)) {
            this.computeExtrema();
        }
        return this.zmax;
    }

    protected abstract void computeCorners();

    protected void computeAbsoluteDifference(double[] dArray) {
        dArray[0] = this.originx * this.sizex;
        dArray[1] = this.originy * this.sizey;
        dArray[2] = this.originz * this.sizez;
    }

    protected void transformPoint(double[] dArray, boolean bl) {
        if (bl) {
            double[] dArray2 = new double[3];
            this.computeAbsoluteDifference(dArray2);
            dArray[0] = dArray[0] - dArray2[0];
            dArray[1] = dArray[1] - dArray2[1];
            dArray[2] = dArray[2] - dArray2[2];
        }
        if (this.transformation != null) {
            dArray[0] = dArray[0] - this.x;
            dArray[1] = dArray[1] - this.y;
            dArray[2] = dArray[2] - this.z;
            this.transformation.direct(dArray);
            dArray[0] = dArray[0] + this.x;
            dArray[1] = dArray[1] + this.y;
            dArray[2] = dArray[2] + this.z;
        }
    }

    protected void transformCorners() {
        if (this.originIsRelative) {
            this.computeAbsoluteDifference(this.coordinates);
        } else {
            this.coordinates[0] = this.originx;
            this.coordinates[1] = this.originy;
            this.coordinates[2] = this.originz;
        }
        for (int i = 0; i < this.numberOfTiles; ++i) {
            int n = this.corners[i].length;
            for (int j = 0; j < n; ++j) {
                double[] dArray = this.corners[i][j];
                dArray[0] = dArray[0] - this.coordinates[0];
                double[] dArray2 = this.corners[i][j];
                dArray2[1] = dArray2[1] - this.coordinates[1];
                double[] dArray3 = this.corners[i][j];
                dArray3[2] = dArray3[2] - this.coordinates[2];
                if (this.transformation == null) continue;
                double[] dArray4 = this.corners[i][j];
                dArray4[0] = dArray4[0] - this.x;
                double[] dArray5 = this.corners[i][j];
                dArray5[1] = dArray5[1] - this.y;
                double[] dArray6 = this.corners[i][j];
                dArray6[2] = dArray6[2] - this.z;
                this.transformation.direct(this.corners[i][j]);
                double[] dArray7 = this.corners[i][j];
                dArray7[0] = dArray7[0] + this.x;
                double[] dArray8 = this.corners[i][j];
                dArray8[1] = dArray8[1] + this.y;
                double[] dArray9 = this.corners[i][j];
                dArray9[2] = dArray9[2] + this.z;
            }
        }
    }

    protected void setCorners(double[][][] dArray) {
        this.corners = dArray;
        if (this.corners == null) {
            this.numberOfTiles = 0;
            this.a = null;
            this.b = null;
            return;
        }
        this.numberOfTiles = this.corners.length;
        this.a = new int[this.numberOfTiles][];
        this.b = new int[this.numberOfTiles][];
        this.objects = new Object3D[this.numberOfTiles];
        for (int i = 0; i < this.numberOfTiles; ++i) {
            int n = this.corners[i].length;
            this.a[i] = new int[n];
            this.b[i] = new int[n];
            this.objects[i] = new Object3D(this, i);
        }
    }

    protected void projectPoints(DrawingPanel drawingPanel) {
        if (this.group == null) {
            this.coordinates[0] = this.x;
            this.coordinates[1] = this.y;
            this.coordinates[2] = this.z;
            this.transformPoint(this.coordinates, false);
            drawingPanel.project(this.coordinates, this.pixelOrigin);
            this.coordinates[0] = this.x + this.sizex;
            this.coordinates[1] = this.y + this.sizey;
            this.coordinates[2] = this.z + this.sizez;
            this.transformPoint(this.coordinates, true);
            drawingPanel.project(this.coordinates, this.pixelEndpoint);
            for (int i = 0; i < this.numberOfTiles; ++i) {
                int n;
                int n2 = this.corners[i].length;
                for (n = 0; n < 3; ++n) {
                    this.center[n] = 0.0;
                }
                for (n = 0; n < n2; ++n) {
                    drawingPanel.project(this.corners[i][n], this.pixel);
                    this.a[i][n] = (int)this.pixel[0];
                    this.b[i][n] = (int)this.pixel[1];
                    for (int j = 0; j < 3; ++j) {
                        int n3 = j;
                        this.center[n3] = this.center[n3] + this.corners[i][n][j];
                    }
                }
                n = 0;
                while (n < 3) {
                    int n4 = n++;
                    this.center[n4] = this.center[n4] / (double)n2;
                }
                drawingPanel.project(this.center, this.pixel);
                this.objects[i].distance = this.pixel[2] * this.displacementFactor;
            }
        } else {
            this.coordinates[0] = this.x;
            this.coordinates[1] = this.y;
            this.coordinates[2] = this.z;
            this.transformPoint(this.coordinates, false);
            this.coordinates[0] = this.group.x + this.coordinates[0] * this.group.sizex;
            this.coordinates[1] = this.group.y + this.coordinates[1] * this.group.sizey;
            this.coordinates[2] = this.group.z + this.coordinates[2] * this.group.sizez;
            drawingPanel.project(this.coordinates, this.pixelOrigin);
            this.coordinates[0] = this.x + this.sizex;
            this.coordinates[1] = this.y + this.sizey;
            this.coordinates[2] = this.z + this.sizez;
            this.transformPoint(this.coordinates, true);
            this.coordinates[0] = this.group.x + this.coordinates[0] * this.group.sizex;
            this.coordinates[1] = this.group.y + this.coordinates[1] * this.group.sizey;
            this.coordinates[2] = this.group.z + this.coordinates[2] * this.group.sizez;
            drawingPanel.project(this.coordinates, this.pixelEndpoint);
            for (int i = 0; i < this.numberOfTiles; ++i) {
                int n;
                int n5 = this.corners[i].length;
                for (n = 0; n < 3; ++n) {
                    this.center[n] = 0.0;
                }
                for (n = 0; n < n5; ++n) {
                    this.coordinates[0] = this.group.x + this.corners[i][n][0] * this.group.sizex;
                    this.coordinates[1] = this.group.y + this.corners[i][n][1] * this.group.sizey;
                    this.coordinates[2] = this.group.z + this.corners[i][n][2] * this.group.sizez;
                    drawingPanel.project(this.coordinates, this.pixel);
                    this.a[i][n] = (int)this.pixel[0];
                    this.b[i][n] = (int)this.pixel[1];
                    for (int j = 0; j < 3; ++j) {
                        int n6 = j;
                        this.center[n6] = this.center[n6] + this.coordinates[j];
                    }
                }
                n = 0;
                while (n < 3) {
                    int n7 = n++;
                    this.center[n7] = this.center[n7] / (double)n5;
                }
                drawingPanel.project(this.center, this.pixel);
                this.objects[i].distance = this.pixel[2] * this.displacementFactor;
            }
        }
        this.panelWithValidProjection = drawingPanel;
    }

    protected void computeExtrema() {
        this.zmin = Double.MAX_VALUE;
        this.ymin = Double.MAX_VALUE;
        this.xmin = Double.MAX_VALUE;
        this.zmax = -1.7976931348623157E308;
        this.ymax = -1.7976931348623157E308;
        this.xmax = -1.7976931348623157E308;
        for (int i = 0; i < this.numberOfTiles; ++i) {
            int n = this.corners[i].length;
            for (int j = 0; j < n; ++j) {
                double d = this.corners[i][j][0];
                if (d < this.xmin) {
                    this.xmin = d;
                }
                if (d > this.xmax) {
                    this.xmax = d;
                }
                if ((d = this.corners[i][j][1]) < this.ymin) {
                    this.ymin = d;
                }
                if (d > this.ymax) {
                    this.ymax = d;
                }
                if ((d = this.corners[i][j][2]) < this.zmin) {
                    this.zmin = d;
                }
                if (!(d > this.zmax)) continue;
                this.zmax = d;
            }
        }
        if (this.group != null) {
            this.xmin = this.group.x + this.xmin * this.group.sizex;
            this.xmax = this.group.x + this.xmax * this.group.sizex;
            this.ymin = this.group.y + this.ymin * this.group.sizey;
            this.ymax = this.group.y + this.ymax * this.group.sizey;
            this.zmin = this.group.z + this.zmin * this.group.sizez;
            this.zmax = this.group.z + this.zmax * this.group.sizez;
        }
    }

    private double levelScalarProduct(double[] dArray) {
        if (this.group == null) {
            return (dArray[0] - this.levelx) * this.leveldx + (dArray[1] - this.levely) * this.leveldy + (dArray[2] - this.levelz) * this.leveldz;
        }
        return (this.group.x + dArray[0] * this.group.sizex - this.levelx) * this.leveldx + (this.group.y + dArray[1] * this.group.sizey - this.levely) * this.leveldy + (this.group.z + dArray[2] * this.group.sizez - this.levelz) * this.leveldz;
    }

    private void drawColorCoded(DrawingPanel3D drawingPanel3D, Graphics2D graphics2D, int n) {
        int n2;
        int n3;
        double d;
        int n4;
        int n5 = this.corners[n].length;
        int[] nArray = new int[n5];
        if (this.levelBelowWhenEqual) {
            block0: for (n4 = 0; n4 < n5; ++n4) {
                nArray[n4] = 0;
                d = this.levelScalarProduct(this.corners[n][n4]);
                for (n3 = this.levelZ.length - 1; n3 >= 0; --n3) {
                    if (!(d > this.levelZ[n3])) continue;
                    nArray[n4] = n3 + 1;
                    continue block0;
                }
            }
        } else {
            block2: for (n4 = 0; n4 < n5; ++n4) {
                nArray[n4] = this.levelZ.length;
                d = this.levelScalarProduct(this.corners[n][n4]);
                n2 = this.levelZ.length;
                for (n3 = 0; n3 < n2; ++n3) {
                    if (!(d < this.levelZ[n3])) continue;
                    nArray[n4] = n3;
                    continue block2;
                }
            }
        }
        int[] nArray2 = new int[n5 * 2];
        int[] nArray3 = new int[n5 * 2];
        n3 = this.levelZ.length;
        for (int i = 0; i <= n3; ++i) {
            n2 = 0;
            for (int j = 0; j < n5; ++j) {
                double d2;
                int n6 = (j + 1) % n5;
                if (nArray[j] <= i && nArray[n6] >= i) {
                    if (nArray[j] == i) {
                        nArray2[n2] = this.a[n][j];
                        nArray3[n2] = this.b[n][j];
                        ++n2;
                    } else {
                        d2 = this.levelScalarProduct(this.corners[n][j]);
                        d2 = (this.levelZ[i - 1] - d2) / (this.levelScalarProduct(this.corners[n][n6]) - d2);
                        nArray2[n2] = (int)Math.round((double)this.a[n][j] + d2 * (double)(this.a[n][n6] - this.a[n][j]));
                        nArray3[n2] = (int)Math.round((double)this.b[n][j] + d2 * (double)(this.b[n][n6] - this.b[n][j]));
                        ++n2;
                    }
                    if (nArray[n6] <= i) continue;
                    d2 = this.levelScalarProduct(this.corners[n][j]);
                    d2 = (this.levelZ[i] - d2) / (this.levelScalarProduct(this.corners[n][n6]) - d2);
                    nArray2[n2] = (int)Math.round((double)this.a[n][j] + d2 * (double)(this.a[n][n6] - this.a[n][j]));
                    nArray3[n2] = (int)Math.round((double)this.b[n][j] + d2 * (double)(this.b[n][n6] - this.b[n][j]));
                    ++n2;
                    continue;
                }
                if (nArray[j] < i || nArray[n6] > i) continue;
                if (nArray[j] == i) {
                    nArray2[n2] = this.a[n][j];
                    nArray3[n2] = this.b[n][j];
                    ++n2;
                } else {
                    d2 = this.levelScalarProduct(this.corners[n][j]);
                    d2 = (this.levelZ[i] - d2) / (this.levelScalarProduct(this.corners[n][n6]) - d2);
                    nArray2[n2] = (int)Math.round((double)this.a[n][j] + d2 * (double)(this.a[n][n6] - this.a[n][j]));
                    nArray3[n2] = (int)Math.round((double)this.b[n][j] + d2 * (double)(this.b[n][n6] - this.b[n][j]));
                    ++n2;
                }
                if (nArray[n6] >= i) continue;
                d2 = this.levelScalarProduct(this.corners[n][j]);
                d2 = (this.levelZ[i - 1] - d2) / (this.levelScalarProduct(this.corners[n][n6]) - d2);
                nArray2[n2] = (int)Math.round((double)this.a[n][j] + d2 * (double)(this.a[n][n6] - this.a[n][j]));
                nArray3[n2] = (int)Math.round((double)this.b[n][j] + d2 * (double)(this.b[n][n6] - this.b[n][j]));
                ++n2;
            }
            if (n2 <= 0) continue;
            Paint paint = this.levelColors[i];
            graphics2D.setPaint(paint);
            graphics2D.fillPolygon(nArray2, nArray3, n2);
        }
        if (this.style.edgeColor != null) {
            graphics2D.setColor(drawingPanel3D.projectColor(this.style.edgeColor, this.objects[n].distance));
            graphics2D.setStroke(this.style.edgeStroke);
            graphics2D.drawPolygon(this.a[n], this.b[n], n5);
        }
    }
}

