/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;
import org.opensourcephysics.display.axes.XYAxis;

public class YAxis
extends XYAxis {
    AffineTransform rot90 = AffineTransform.getRotateInstance(-1.5707963267948966);

    public YAxis() {
        this("Y Axis");
    }

    public YAxis(String string) {
        this.setTitle(string);
        this.axisLabel.setTheta(1.5707963267948966);
    }

    public void draw(DrawingPanel drawingPanel, Graphics graphics) {
        int n = drawingPanel.xToPix(this.location);
        if (n < 1) {
            this.location = drawingPanel.getXMin();
        }
        if (n > drawingPanel.getWidth() - 1) {
            this.location = drawingPanel.getXMax();
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        Shape shape = graphics2D.getClip();
        graphics2D.clipRect(0, 0, drawingPanel.getWidth(), drawingPanel.getHeight());
        switch (this.locationType) {
            case 0: 
            case 2: {
                this.drawInsideDisplay(drawingPanel, graphics);
                break;
            }
            case 1: {
                this.drawInsideGutter(drawingPanel, graphics);
                break;
            }
            default: {
                this.drawInsideDisplay(drawingPanel, graphics);
            }
        }
        graphics2D.setClip(shape);
    }

    private void drawInsideDisplay(DrawingPanel drawingPanel, Graphics graphics) {
        int n = drawingPanel.getBottomGutter();
        int n2 = drawingPanel.getRightGutter();
        int n3 = drawingPanel.getLeftGutter();
        int n4 = drawingPanel.getTopGutter();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = 0;
        graphics.setColor(this.color);
        if (this.locationType == 0) {
            this.location = (drawingPanel.getXMax() + drawingPanel.getXMin()) / 2.0;
        }
        int n6 = drawingPanel.xToPix(this.location);
        int n7 = drawingPanel.getHeight() - n;
        int n8 = drawingPanel.getHeight() - n - n4;
        this.calculateLabels(drawingPanel.getYMin(), drawingPanel.getYMax(), 1 + n8 / 35);
        String[] stringArray = this.label_string;
        double[] dArray = this.label_value;
        if (stringArray.length != dArray.length) {
            return;
        }
        int n9 = dArray.length;
        for (int i = 0; i < n9; ++i) {
            int n10;
            if (this.axisType == 0) {
                n10 = drawingPanel.yToPix(dArray[i] * this.decade_multiplier);
                if (this.showMajorGrid) {
                    graphics.setColor(this.majorGridColor);
                    graphics.drawLine(n3, n10, drawingPanel.getWidth() - n2 - 2, n10);
                    graphics.setColor(this.color);
                }
                graphics.drawLine(n6 - 5, n10, n6 + 5, n10);
                n5 = fontMetrics.stringWidth(stringArray[i]);
                graphics.drawString(stringArray[i], n6 - n5 - 7, n10 + 5);
                continue;
            }
            n10 = drawingPanel.yToPix(Math.pow(10.0, dArray[i] * this.decade_multiplier));
            if (this.showMajorGrid) {
                graphics.setColor(this.majorGridColor);
                graphics.drawLine(n3, n10, drawingPanel.getWidth() - n2 - 2, n10);
                graphics.setColor(this.color);
            }
            graphics.drawLine(n6 - 5, n10, n6 + 5, n10);
            n5 = fontMetrics.stringWidth(this.logBase);
            this.drawMultiplier(n6 - n5 - 7, n10 + 5, (int)dArray[i], (Graphics2D)graphics);
        }
        graphics.drawLine(n6, n7, n6, n7 - n8);
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.axisType == 0 && this.label_exponent != 0) {
            graphics2D.setColor(Color.red);
            graphics2D.drawString("x10", 5, 18);
            graphics2D.setFont(graphics2D.getFont().deriveFont(0, 9.0f));
            graphics2D.drawString("" + this.label_exponent, 25, 12);
        }
        graphics2D.setColor(Color.black);
        if (this.axisLabel != null) {
            this.axisLabel.setY((drawingPanel.getYMax() + drawingPanel.getYMin()) / 2.0);
            this.axisLabel.setX(drawingPanel.pixToX(Math.max(n3 / 2 - 10, 18)));
            this.axisLabel.draw(drawingPanel, graphics2D);
        }
    }

    private void drawInsideGutter(DrawingPanel drawingPanel, Graphics graphics) {
        int n = drawingPanel.getBottomGutter();
        int n2 = drawingPanel.getRightGutter();
        int n3 = drawingPanel.getLeftGutter();
        int n4 = drawingPanel.getTopGutter();
        FontMetrics fontMetrics = graphics.getFontMetrics();
        int n5 = 0;
        graphics.setColor(this.color);
        int n6 = n3;
        int n7 = drawingPanel.getHeight() - n - 1;
        int n8 = drawingPanel.getHeight() - n - n4;
        graphics.drawLine(n6, n7, n6, n7 - n8);
        this.calculateLabels(drawingPanel.getYMin(), drawingPanel.getYMax(), 1 + n8 / 35);
        String[] stringArray = this.label_string;
        double[] dArray = this.label_value;
        if (stringArray.length != dArray.length) {
            return;
        }
        int n9 = dArray.length;
        for (int i = 0; i < n9; ++i) {
            int n10;
            if (this.axisType == 0) {
                n10 = drawingPanel.yToPix(dArray[i] * this.decade_multiplier);
                if (this.showMajorGrid) {
                    graphics.setColor(this.majorGridColor);
                    graphics.drawLine(n6, n10, drawingPanel.getWidth() - n2 - 2, n10);
                    graphics.setColor(this.color);
                }
                graphics.drawLine(n6 - 5, n10, n6, n10);
                n5 = fontMetrics.stringWidth(stringArray[i]);
                graphics.drawString(stringArray[i], n6 - n5 - 7, n10 + 5);
                continue;
            }
            n10 = drawingPanel.yToPix(Math.pow(10.0, dArray[i] * this.decade_multiplier));
            if (this.showMajorGrid) {
                graphics.setColor(this.majorGridColor);
                graphics.drawLine(n6, n10, drawingPanel.getWidth() - n2 - 2, n10);
                graphics.setColor(this.color);
            }
            graphics.drawLine(n6 - 5, n10, n6, n10);
            n5 = fontMetrics.stringWidth(this.logBase);
            this.drawMultiplier(n6 - n5 - 14, n10 + 5, (int)dArray[i], (Graphics2D)graphics);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.axisType == 0 && this.label_exponent != 0) {
            graphics2D.setColor(Color.red);
            graphics2D.drawString("x10", 5, 18);
            graphics2D.setFont(graphics2D.getFont().deriveFont(0, 9.0f));
            graphics2D.drawString("" + this.label_exponent, 25, 12);
        }
        graphics2D.setColor(Color.black);
        if (this.axisLabel != null) {
            this.axisLabel.setY((drawingPanel.getYMax() + drawingPanel.getYMin()) / 2.0);
            this.axisLabel.setX(drawingPanel.pixToX(Math.max(n3 / 2 - 10, 18)));
            this.axisLabel.draw(drawingPanel, graphics2D);
        }
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        if (!this.enabled) {
            return null;
        }
        if (Math.abs(drawingPanel.xToPix(this.location) - n) < 2) {
            return this;
        }
        return null;
    }

    public void setXY(double d, double d2) {
        this.location = d;
    }

    public void setX(double d) {
        this.location = d;
    }
}

