/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.text.DecimalFormat;
import org.opensourcephysics.display.DrawableTextLine;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.Interactive;

public abstract class XYAxis
implements Interactive {
    public static final int DRAW_IN_DISPLAY = 0;
    public static final int DRAW_IN_GUTTER = 1;
    public static final int DRAW_AT_LOCATION = 2;
    public static final int LINEAR = 0;
    protected double x = 0.0;
    protected double y = 0.0;
    boolean enabled = false;
    public static final int LOG10 = 1;
    int locationType = 0;
    int axisType = 0;
    String logBase = "10";
    DecimalFormat labelFormat = new DecimalFormat("0.0");
    DecimalFormat integerFormat = new DecimalFormat("000");
    Color color = Color.black;
    double label_step = -14.0;
    double label_start = 2.0;
    DrawableTextLine axisLabel = new DrawableTextLine("x", 0.0, 0.0);
    Font labelFont = new Font("Dialog", 0, 12);
    int label_exponent = 0;
    String[] label_string = new String[0];
    double[] label_value = new double[0];
    double decade_multiplier = 1.0;
    int label_count = 0;
    double location = 0.0;
    Font titleFont = new Font("Dialog", 0, 12);
    boolean showMajorGrid = false;
    Color majorGridColor = new Color(0, 0, 0, 32);

    public XYAxis() {
        this.axisLabel.setJustification(0);
        this.axisLabel.setFont(this.labelFont);
    }

    public abstract void draw(DrawingPanel var1, Graphics var2);

    public void setLabelFormat(DecimalFormat decimalFormat) {
        if (decimalFormat != null) {
            this.labelFormat = decimalFormat;
        }
    }

    public void setLabelFormat(String string) {
        this.labelFormat = new DecimalFormat(string);
    }

    public void setLocationType(int n) {
        this.locationType = n;
    }

    public void setLocation(double d) {
        this.location = d;
    }

    public void setAxisType(int n) {
        this.axisType = n;
    }

    public void setTitle(String string, String string2) {
        this.axisLabel.setText(string);
        if (string2 == null || string2.equals("")) {
            return;
        }
        this.axisLabel.setFont(Font.decode(string2));
    }

    public void setTitle(String string) {
        this.axisLabel.setText(string);
    }

    public void setTitleFont(String string) {
        if (string != null && !string.equals("")) {
            this.titleFont = Font.decode(string);
        }
    }

    public void setShowMajorGrid(boolean bl) {
        this.showMajorGrid = bl;
    }

    protected void drawMultiplier(int n, int n2, int n3, Graphics2D graphics2D) {
        Font font = graphics2D.getFont();
        graphics2D.drawString("10", n, n2);
        graphics2D.setFont(graphics2D.getFont().deriveFont(0, 9.0f));
        graphics2D.drawString("" + n3, n + 16, n2 - 6);
        graphics2D.setFont(font);
    }

    public void calculateLabels(double d, double d2, int n) {
        n = Math.min(19, n);
        double d3 = d;
        double d4 = d2;
        if (d2 < d) {
            d3 = d2;
            d4 = d;
        } else {
            d4 = d2;
            d3 = d;
        }
        switch (this.axisType) {
            case 0: {
                this.calculateLinearLabels(d3, d4, n);
                break;
            }
            case 1: {
                this.calculateLogLabels(d3, d4, n);
                break;
            }
            default: {
                this.calculateLinearLabels(d3, d4, n);
            }
        }
    }

    private void calculateLogLabels(double d, double d2, int n) {
        this.label_exponent = 0;
        this.decade_multiplier = 1.0;
        int n2 = 1;
        int n3 = (int)Math.ceil(d);
        if ((double)n3 - d > 0.998) {
            --n3;
        }
        int n4 = n3;
        this.label_count = 1;
        do {
            ++this.label_count;
        } while ((double)(n4 += n2) <= d2 - (double)n2);
        this.label_string = new String[this.label_count];
        this.label_value = new double[this.label_count];
        for (int i = 0; i < this.label_count; ++i) {
            n4 = n3 + i * n2;
            this.label_string[i] = this.integerFormat.format(n4);
            this.label_value[i] = n4;
        }
    }

    private void calculateLinearLabels(double d, double d2, int n) {
        int n2;
        if (Math.abs(d) == 0.0 && Math.abs(d2) == 0.0) {
            d2 = d + 1.0E-6;
        }
        this.label_exponent = Math.abs(d) > Math.abs(d2) ? (int)Math.floor(XYAxis.log10(Math.abs(d)) / 2.0) * 2 : (int)Math.floor(XYAxis.log10(Math.abs(d2)) / 2.0) * 2;
        this.label_step = d2 - d > (double)(10 * n) * Double.MIN_VALUE ? this.RoundUp((d2 - d) / (double)n) : 1.0;
        this.label_start = Math.floor(d / this.label_step) * this.label_step;
        while (this.label_step > 0.0 && this.label_start < d) {
            this.label_start += this.label_step;
        }
        double d3 = this.label_start;
        this.label_count = 1;
        while (d3 <= d2 - this.label_step) {
            d3 += this.label_step;
            ++this.label_count;
        }
        this.label_string = new String[this.label_count];
        this.label_value = new double[this.label_count];
        for (int i = 0; i < this.label_count; ++i) {
            d3 = this.label_start + (double)i * this.label_step;
            if (this.label_exponent < 0) {
                for (n2 = this.label_exponent; n2 < 0; ++n2) {
                    d3 *= 10.0;
                }
            } else {
                for (n2 = 0; n2 < this.label_exponent; ++n2) {
                    d3 /= 10.0;
                }
            }
            this.label_string[i] = this.labelFormat.format(d3);
            this.label_value[i] = d3;
        }
        this.decade_multiplier = 1.0;
        if (this.label_exponent < 0) {
            for (n2 = this.label_exponent; n2 < 0; ++n2) {
                this.decade_multiplier /= 10.0;
            }
        } else {
            for (n2 = 0; n2 < this.label_exponent; ++n2) {
                this.decade_multiplier *= 10.0;
            }
        }
    }

    private double RoundUp(double d) {
        int n;
        int n2 = (int)Math.floor(XYAxis.log10(d));
        if (n2 < 0) {
            for (n = n2; n < 0; ++n) {
                d *= 10.0;
            }
        } else {
            for (n = 0; n < n2; ++n) {
                d /= 10.0;
            }
        }
        d = d > 5.0 ? 10.0 : (d > 2.0 ? 5.0 : (d > 1.0 ? 2.0 : 1.0));
        if (n2 < 0) {
            for (n = n2; n < 0; ++n) {
                d /= 10.0;
            }
        } else {
            for (n = 0; n < n2; ++n) {
                d *= 10.0;
            }
        }
        return d;
    }

    public double getXMin() {
        return 0.0;
    }

    public double getXMax() {
        return 0.0;
    }

    public double getYMin() {
        return 0.0;
    }

    public double getYMax() {
        return 0.0;
    }

    public boolean isMeasured() {
        return false;
    }

    public Interactive findInteractive(DrawingPanel drawingPanel, int n, int n2) {
        return null;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setXY(double d, double d2) {
    }

    public void setX(double d) {
    }

    public void setY(double d) {
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public static double log10(double d) throws ArithmeticException {
        if (d <= 0.0) {
            throw new ArithmeticException("range exception");
        }
        return Math.log(d) / 2.302585092994046;
    }
}

