/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display.axes;

import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import org.opensourcephysics.display.DrawingPanel;
import org.opensourcephysics.display.InteractivePanel;
import org.opensourcephysics.display.axes.CoordinateStringBuilder;

public class CartesianCoordinateStringBuilder
extends CoordinateStringBuilder {
    protected DecimalFormat scientificFormat = new DecimalFormat("0.###E0");
    protected DecimalFormat decimalFormat = new DecimalFormat("0.00");
    protected String xLabel = "x=";
    protected String yLabel = "  y=";

    public CartesianCoordinateStringBuilder() {
        this("x=", "  y=");
    }

    public CartesianCoordinateStringBuilder(String string, String string2) {
        this.xLabel = string;
        this.yLabel = string2;
    }

    public void setCoordinateLabels(String string, String string2) {
        this.xLabel = string;
        this.yLabel = string2;
    }

    public String getCoordinateString(DrawingPanel drawingPanel, MouseEvent mouseEvent) {
        double d = drawingPanel.pixToX(mouseEvent.getPoint().x);
        double d2 = drawingPanel.pixToY(mouseEvent.getPoint().y);
        if (drawingPanel instanceof InteractivePanel && ((InteractivePanel)drawingPanel).getCurrentDraggable() != null) {
            d = ((InteractivePanel)drawingPanel).getCurrentDraggable().getX();
            d2 = ((InteractivePanel)drawingPanel).getCurrentDraggable().getY();
        }
        String string = "";
        if (Math.abs(d) > 100.0 || Math.abs(d) < 0.01 || Math.abs(d2) > 100.0 || Math.abs(d2) < 0.01) {
            if (this.xLabel != null) {
                string = this.xLabel + this.scientificFormat.format((float)d);
            }
            if (this.yLabel != null) {
                string = string + this.yLabel + this.scientificFormat.format((float)d2);
            }
        } else {
            if (this.xLabel != null) {
                string = this.xLabel + this.decimalFormat.format((float)d);
            }
            if (this.yLabel != null) {
                string = string + this.yLabel + this.decimalFormat.format((float)d2);
            }
        }
        return string;
    }
}

