/*
 * Decompiled with CFR 0.152.
 */
package org.opensourcephysics.display;

import java.awt.Component;
import java.io.File;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.swing.JApplet;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.opensourcephysics.controls.XML;
import org.opensourcephysics.display.DisplayRes;
import org.opensourcephysics.tools.Translator;

public class OSPRuntime {
    static String version = "1.2";
    static String releaseDate = "Oct 22, 2007";
    public static Translator translator;
    public static Locale[] defaultLocales;
    protected static boolean launcherMode;
    public static boolean appletMode;
    public static JApplet applet;
    public static boolean webStart;
    protected static boolean authorMode;
    public static boolean javaLookAndFeel;
    private static String launchJarPath;
    private static String launchJarName;
    private static JarFile launchJar;
    public static String chooserDir;
    public static final String OSP_ICON_FILE = "/org/opensourcephysics/resources/controls/images/osp_icon.gif";
    public static boolean launchingInSingleVM;
    private static JFileChooser chooser;

    private OSPRuntime() {
    }

    public static void showAboutDialog(Component component) {
        String string = "OSP Library " + version + " released " + releaseDate + "\n" + "Open Source Physics Project \n" + "www.opensourcephysics.org";
        JOptionPane.showMessageDialog(component, string, "About Open Source Physics", 1);
    }

    public static boolean isWindows() {
        try {
            return System.getProperty("os.name", "").toLowerCase().startsWith("windows");
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static boolean isMac() {
        try {
            return System.getProperty("os.name", "").toLowerCase().startsWith("mac");
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static boolean isLinux() {
        try {
            return System.getProperty("os.name", "").toLowerCase().startsWith("linux");
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static boolean isVista() {
        return System.getProperty("os.name", "").toLowerCase().indexOf("vista") > -1;
    }

    public static boolean isWebStart() {
        if (!webStart) {
            try {
                webStart = Class.forName("javax.jnlp.BasicService") != null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return webStart;
    }

    public static boolean isAppletMode() {
        return appletMode;
    }

    public static boolean isAuthorMode() {
        return authorMode;
    }

    public static void setAuthorMode(boolean bl) {
        authorMode = bl;
    }

    public static void setLauncherMode(boolean bl) {
        launcherMode = bl;
    }

    public static boolean isLauncherMode() {
        return launcherMode;
    }

    public static void setLaunchJarPath(String string) {
        if (string == null || launchJarPath != null) {
            return;
        }
        if (!string.endsWith(".jar")) {
            int n = string.indexOf(".jar!");
            if (n > -1) {
                string = string.substring(0, n + 4);
            } else {
                return;
            }
        }
        launchJarPath = string;
        launchJarName = string.substring(string.lastIndexOf("/") + 1);
    }

    public static String getLaunchJarName() {
        return launchJarName;
    }

    public static String getLaunchJarPath() {
        return launchJarPath;
    }

    public static String getLaunchJarDirectory() {
        if (applet != null) {
            return null;
        }
        return launchJarPath == null ? null : XML.getDirectoryPath(launchJarPath);
    }

    public static JarFile getLaunchJar() {
        if (launchJar != null) {
            return launchJar;
        }
        if (launchJarPath == null) {
            return null;
        }
        boolean bl = launchJarPath.startsWith("http:");
        try {
            if (applet == null && !bl) {
                launchJar = new JarFile(launchJarPath);
            } else {
                URL uRL = bl ? new URL("jar:" + launchJarPath + "!/") : new URL("jar:file:/" + launchJarPath + "!/");
                JarURLConnection jarURLConnection = (JarURLConnection)uRL.openConnection();
                launchJar = jarURLConnection.getJarFile();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return launchJar;
    }

    public static Locale[] getDefaultLocales() {
        return defaultLocales;
    }

    public static Locale[] getInstalledLocales() {
        ArrayList<Locale> arrayList = new ArrayList<Locale>();
        arrayList.add(Locale.ENGLISH);
        if (OSPRuntime.getLaunchJarPath() != null) {
            JarFile jarFile = OSPRuntime.getLaunchJar();
            if (jarFile != null) {
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    int n;
                    JarEntry jarEntry = enumeration.nextElement();
                    String string = jarEntry.toString();
                    int n2 = string.indexOf(".properties");
                    if (string.indexOf(".properties") <= -1 || (n = string.indexOf("display_res_")) <= -1) continue;
                    String string2 = string.substring(n + 12, n2);
                    if (string2.equals("zh_TW")) {
                        arrayList.add(Locale.TAIWAN);
                        continue;
                    }
                    Locale locale = new Locale(string2);
                    if (locale.equals(Locale.ENGLISH)) continue;
                    arrayList.add(locale);
                }
            } else {
                defaultLocales = new Locale[]{Locale.ENGLISH};
                return defaultLocales;
            }
        }
        return arrayList.toArray(new Locale[0]);
    }

    public static Translator getTranslator() {
        return translator;
    }

    public static JFileChooser getChooser() {
        if (chooser != null) {
            return chooser;
        }
        try {
            chooser = chooserDir == null ? new JFileChooser() : new JFileChooser(new File(chooserDir));
        }
        catch (Exception exception) {
            System.err.println("Exception in OSPFrame getChooser=" + exception);
            return null;
        }
        FileFilter fileFilter = chooser.getFileFilter();
        FileFilter fileFilter2 = new FileFilter(){

            public boolean accept(File file) {
                if (file == null) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                String string = null;
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                if (n > 0 && n < string2.length() - 1) {
                    string = string2.substring(n + 1).toLowerCase();
                }
                return string != null && string.equals("xml");
            }

            public String getDescription() {
                return DisplayRes.getString("OSPRuntime.FileFilter.Description.XML");
            }
        };
        FileFilter fileFilter3 = new FileFilter(){

            public boolean accept(File file) {
                if (file == null) {
                    return false;
                }
                if (file.isDirectory()) {
                    return true;
                }
                String string = null;
                String string2 = file.getName();
                int n = string2.lastIndexOf(46);
                if (n > 0 && n < string2.length() - 1) {
                    string = string2.substring(n + 1).toLowerCase();
                }
                return string != null && string.equals("txt");
            }

            public String getDescription() {
                return DisplayRes.getString("OSPRuntime.FileFilter.Description.TXT");
            }
        };
        chooser.addChoosableFileFilter(fileFilter2);
        chooser.addChoosableFileFilter(fileFilter3);
        chooser.setFileFilter(fileFilter);
        return chooser;
    }

    public static String chooseFilename(JFileChooser jFileChooser) {
        return OSPRuntime.chooseFilename(jFileChooser, null, true);
    }

    public static String chooseFilename(JFileChooser jFileChooser, Component component, boolean bl) {
        String string = null;
        int n = bl ? jFileChooser.showSaveDialog(component) : jFileChooser.showOpenDialog(component);
        if (n == 0) {
            chooserDir = jFileChooser.getCurrentDirectory().toString();
            File file = jFileChooser.getSelectedFile();
            if (bl) {
                int n2;
                if (file.exists() && (n2 = JOptionPane.showConfirmDialog(component, DisplayRes.getString("DrawingFrame.ReplaceExisting_message") + " " + file.getName() + DisplayRes.getString("DrawingFrame.QuestionMark"), DisplayRes.getString("DrawingFrame.ReplaceFile_option_title"), 1)) != 0) {
                    return null;
                }
            } else if (!file.exists()) {
                JOptionPane.showMessageDialog(component, DisplayRes.getString("GUIUtils.FileDoesntExist") + " " + file.getName(), DisplayRes.getString("GUIUtils.FileChooserError"), 0);
                return null;
            }
            if ((string = file.getAbsolutePath()) == null || string.trim().equals("")) {
                return null;
            }
        }
        return string;
    }

    public static JFileChooser createChooser(String string, String[] stringArray) {
        JFileChooser jFileChooser = new JFileChooser(new File(chooserDir));
        ExtensionFileFilter extensionFileFilter = new ExtensionFileFilter();
        for (int i = 0; i < stringArray.length; ++i) {
            extensionFileFilter.addExtension(stringArray[i]);
        }
        extensionFileFilter.setDescription(string);
        jFileChooser.setFileFilter(extensionFileFilter);
        return jFileChooser;
    }

    static {
        defaultLocales = new Locale[]{Locale.ENGLISH, new Locale("es"), new Locale("de"), new Locale("da"), new Locale("sk"), Locale.TAIWAN};
        launcherMode = false;
        authorMode = true;
        javaLookAndFeel = false;
        launchJar = null;
        JFrame.setDefaultLookAndFeelDecorated(javaLookAndFeel);
        JDialog.setDefaultLookAndFeelDecorated(javaLookAndFeel);
        try {
            chooserDir = System.getProperty("user.dir", null);
        }
        catch (Exception exception) {
            chooserDir = null;
        }
        try {
            Class<?> clazz = Class.forName("org.opensourcephysics.tools.TranslatorTool");
            Method method = clazz.getMethod("getTool", null);
            translator = (Translator)method.invoke(null, (Object[])null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class ExtensionFileFilter
    extends FileFilter {
        private String description = "";
        private ArrayList extensions = new ArrayList();

        private ExtensionFileFilter() {
        }

        public void addExtension(String string) {
            if (!string.startsWith(".")) {
                string = "." + string;
            }
            this.extensions.add(string.toLowerCase());
        }

        public void setDescription(String string) {
            this.description = string;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean accept(File file) {
            if (file.isDirectory()) {
                return true;
            }
            String string = file.getName().toLowerCase();
            for (int i = 0; i < this.extensions.size(); ++i) {
                if (!string.endsWith((String)this.extensions.get(i))) continue;
                return true;
            }
            return false;
        }
    }
}

