/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.view;

import edu.colorado.phet.common.phetgraphics.view.graphics.mousecontrols.translation.TranslationEvent;
import edu.colorado.phet.common.phetgraphics.view.graphics.mousecontrols.translation.TranslationListener;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.idealgas.collision.Wall;
import edu.colorado.phet.idealgas.coreadditions.Translatable;
import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;

public class WallGraphic
extends PhetShapeGraphic
implements Wall.ChangeListener {
    public static final Object NORTH = new Object();
    private Wall wall;
    private boolean isResizable = false;
    private boolean isResizingEast = false;
    private boolean isResizingWest = false;
    private boolean isResizingNorth = false;
    private boolean isResizingSouth = false;
    private double hotSpotRadius = 4.0;
    private int strokeWidth = 1;
    private Paint normalBorderPaint;
    private boolean isWallHighlightedByMouse;
    private boolean isMovable;
    private boolean isResizableNorth = true;
    private boolean isResizableSouth = true;
    private boolean isResizableEast = true;
    private boolean isResizableWest = true;
    boolean testFlag = false;

    public WallGraphic(Wall wall, Component component, Paint paint, Paint paint2, int n) {
        this(wall, component, paint, n);
        this.setStroke(new BasicStroke(this.strokeWidth));
        this.setBorderPaint(paint2);
        this.normalBorderPaint = paint2;
    }

    public WallGraphic(Wall wall, Component component, Paint paint, int n) {
        super(component, wall.getBounds(), paint);
        this.wall = wall;
        wall.addChangeListener(this);
        this.addTranslationListener(new Resizer());
        if (n == 1) {
            this.addTranslationListener(new EastWestTranslator(wall));
        }
        if (n == 2) {
            this.addTranslationListener(new NorthSouthTranslator(wall));
        }
        if (n == 0) {
            this.addTranslationListener(new NorthSouthTranslator(wall));
            this.addTranslationListener(new EastWestTranslator(wall));
        }
        this.setCursorHand();
        component.addMouseListener(new ResizingDetector(wall));
    }

    public void setIsResizable(boolean bl) {
        this.isResizable = bl;
    }

    public void setWallHighlightedByMouse(boolean bl) {
        this.isWallHighlightedByMouse = bl;
    }

    public void paint(Graphics2D graphics2D) {
        this.saveGraphicsState(graphics2D);
        super.paint(graphics2D);
        this.restoreGraphicsState();
    }

    public void setMovable(boolean bl) {
        this.isMovable = bl;
    }

    public void setResizableNorth(boolean bl) {
        this.isResizableNorth = bl;
    }

    public void setResizableSouth(boolean bl) {
        this.isResizableSouth = bl;
    }

    public void setResizableEast(boolean bl) {
        this.isResizableEast = bl;
    }

    public void setResizableWest(boolean bl) {
        this.isResizableWest = bl;
    }

    public void wallChanged(Wall.ChangeEvent changeEvent) {
        Wall wall = changeEvent.getWall();
        this.setShape(new Rectangle((int)wall.getBounds().getX(), (int)wall.getBounds().getY(), (int)wall.getBounds().getWidth(), (int)wall.getBounds().getHeight()));
        this.testFlag = true;
        this.setBoundsDirty();
        this.repaint();
    }

    protected Rectangle determineBounds() {
        return super.determineBounds();
    }

    private class EastWestTranslator
    implements TranslationListener {
        private Translatable translatable;

        public EastWestTranslator(Translatable translatable) {
            this.translatable = translatable;
        }

        public void translationOccurred(TranslationEvent translationEvent) {
            if (!(WallGraphic.this.isResizingNorth || WallGraphic.this.isResizingSouth || WallGraphic.this.isResizingEast || WallGraphic.this.isResizingWest)) {
                this.translatable.translate(translationEvent.getDx(), 0.0);
            }
        }
    }

    private class NorthSouthTranslator
    implements TranslationListener {
        private Translatable translatable;

        public NorthSouthTranslator(Translatable translatable) {
            this.translatable = translatable;
        }

        public void translationOccurred(TranslationEvent translationEvent) {
            if (!(WallGraphic.this.isResizingNorth || WallGraphic.this.isResizingSouth || WallGraphic.this.isResizingEast || WallGraphic.this.isResizingWest)) {
                this.translatable.translate(0.0, translationEvent.getDy());
            }
        }
    }

    protected class Resizer
    implements TranslationListener {
        protected Resizer() {
        }

        public void translationOccurred(TranslationEvent translationEvent) {
            if (WallGraphic.this.isResizable) {
                double d = WallGraphic.this.wall.getBounds().getMinX();
                double d2 = WallGraphic.this.wall.getBounds().getMaxX();
                double d3 = WallGraphic.this.wall.getBounds().getMinY();
                double d4 = WallGraphic.this.wall.getBounds().getMaxY();
                Point point = translationEvent.getMouseEvent().getPoint();
                if (WallGraphic.this.isResizingNorth) {
                    d3 = point.y;
                }
                if (WallGraphic.this.isResizingSouth) {
                    d4 = point.y;
                }
                if (WallGraphic.this.isResizingWest) {
                    d = point.x;
                }
                if (WallGraphic.this.isResizingEast) {
                    d2 = point.x;
                }
                WallGraphic.this.wall.setBounds(new Rectangle2D.Double(d, d3, d2 - d, d4 - d3));
            }
        }
    }

    private class ResizingDetector
    extends MouseAdapter {
        private final Wall wall;

        public ResizingDetector(Wall wall) {
            this.wall = wall;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (WallGraphic.this.isResizable) {
                double d = this.wall.getBounds().getMinX();
                double d2 = this.wall.getBounds().getMaxX();
                double d3 = this.wall.getBounds().getMinY();
                double d4 = this.wall.getBounds().getMaxY();
                Point point = mouseEvent.getPoint();
                if (Math.abs((double)point.y - d3) <= WallGraphic.this.hotSpotRadius && WallGraphic.this.isResizableNorth) {
                    WallGraphic.this.isResizingNorth = true;
                } else if (Math.abs((double)point.y - d4) <= WallGraphic.this.hotSpotRadius && WallGraphic.this.isResizableSouth) {
                    WallGraphic.this.isResizingSouth = true;
                } else if (Math.abs((double)point.x - d) <= WallGraphic.this.hotSpotRadius && WallGraphic.this.isResizableWest) {
                    WallGraphic.this.isResizingWest = true;
                } else if (Math.abs((double)point.x - d2) <= WallGraphic.this.hotSpotRadius && WallGraphic.this.isResizableEast) {
                    WallGraphic.this.isResizingEast = true;
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            WallGraphic.this.isResizingEast = false;
            WallGraphic.this.isResizingWest = false;
            WallGraphic.this.isResizingNorth = false;
            WallGraphic.this.isResizingSouth = false;
        }
    }
}

