/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.model;

import edu.colorado.phet.common.mechanics.Body;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import edu.colorado.phet.idealgas.model.Box2D;
import edu.colorado.phet.idealgas.model.GasMolecule;
import edu.colorado.phet.idealgas.model.IdealGasClock;
import edu.colorado.phet.idealgas.model.IdealGasModel;
import edu.colorado.phet.idealgas.util.ScalarDataRecorder;
import java.util.List;

public class PressureSlice
extends SimpleObservable
implements ModelElement {
    private static double s_defaultTimeAveWindow = 5.0;
    private double y;
    private ScalarDataRecorder pressureRecorder;
    private ScalarDataRecorder temperatureRecorder;
    private Box2D box;
    private IdealGasModel model;
    private double scaleFactor = 0.025;
    private double timeScale;
    private double timeOfLastUpdate;
    private double timeAveWindow = s_defaultTimeAveWindow;
    boolean updateContinuously = true;

    public PressureSlice(Box2D box2D, IdealGasModel idealGasModel, IdealGasClock idealGasClock) {
        this.box = box2D;
        this.model = idealGasModel;
        this.timeScale = idealGasClock.getDt() / (double)idealGasClock.getDelay();
        this.pressureRecorder = new ScalarDataRecorder(idealGasClock);
        this.pressureRecorder.setTimeWindow(this.timeAveWindow);
        this.temperatureRecorder = new ScalarDataRecorder(idealGasClock);
        this.temperatureRecorder.setTimeWindow(this.timeAveWindow);
    }

    public void stepInTime(double d) {
        List list = this.model.getBodies();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            GasMolecule gasMolecule;
            Body body = (Body)list.get(i);
            if (!(body instanceof GasMolecule) || (gasMolecule = (GasMolecule)body).getPositionPrev() == null || !((gasMolecule.getPositionPrev().getY() - this.y) * (gasMolecule.getPosition().getY() - this.y) < 0.0)) continue;
            d2 += Math.abs(gasMolecule.getVelocity().getY() * gasMolecule.getMass());
            d3 += gasMolecule.getKineticEnergy();
            d4 += 1.0;
        }
        this.pressureRecorder.addDataRecordEntry(d2);
        if (d4 > 0.0) {
            this.temperatureRecorder.addDataRecordEntry(d3 / d4);
        }
        if (this.updateContinuously || (double)System.currentTimeMillis() - this.timeOfLastUpdate > this.timeAveWindow / this.timeScale) {
            this.pressureRecorder.computeDataStatistics();
            this.temperatureRecorder.computeDataStatistics();
            this.notifyObservers();
            this.timeOfLastUpdate = System.currentTimeMillis();
        }
    }

    public void clear() {
        this.pressureRecorder.clear();
        this.temperatureRecorder.clear();
    }

    public double getPressure() {
        double d = this.pressureRecorder.getDataTotal() / this.pressureRecorder.getTimeWindow();
        double d2 = this.box.getMaxX() - this.box.getMinX();
        return this.scaleFactor * d / d2;
    }

    public double getTemperature() {
        return this.temperatureRecorder.getDataAverage() / 50.0;
    }

    public void setY(double d) {
        this.y = d;
    }

    public double getY() {
        return this.y;
    }

    public void setTimeAveragingWindow(double d) {
        this.timeAveWindow = d;
        this.temperatureRecorder.setTimeWindow(d);
        this.pressureRecorder.setTimeWindow(d);
    }

    public double getTimeAveragingWindow() {
        return this.timeAveWindow;
    }

    public void setUpdateContinuously(boolean bl) {
        this.updateContinuously = bl;
    }
}

