/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.model;

import edu.colorado.phet.common.mechanics.Body;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.idealgas.model.GasMolecule;
import edu.colorado.phet.idealgas.model.HollowSphere;
import edu.colorado.phet.idealgas.model.IdealGasModel;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.EventListener;
import java.util.EventObject;
import java.util.List;

public class HotAirBalloon
extends HollowSphere {
    private Rectangle2D.Double opening;
    private double theta;
    private IdealGasModel model;
    private double oxOffset;
    private double oyOffset;
    private double heatSource;
    private EventChannel changeEventChannel = new EventChannel(ChangeListener.class);
    private ChangeListener changeListenerProxy = (ChangeListener)this.changeEventChannel.getListenerProxy();

    public HotAirBalloon(Point2D point2D, MutableVector2D mutableVector2D, MutableVector2D mutableVector2D2, double d, double d2, double d3, IdealGasModel idealGasModel) {
        super(point2D, mutableVector2D, mutableVector2D2, d, d2);
        this.theta = d3;
        this.model = idealGasModel;
        this.setOpening();
    }

    public double getOpeningAngle() {
        return this.theta;
    }

    public void stepInTime(double d) {
        super.stepInTime(d);
        double d2 = this.theta * Math.PI / 180.0;
        this.oxOffset = this.getRadius() * Math.sin(d2 / 2.0);
        this.oyOffset = this.getRadius() * Math.cos(d2 / 2.0);
        this.setOpening();
        if (this.heatSource != 0.0) {
            List list = this.model.getBodies();
            for (int i = 0; i < list.size(); ++i) {
                Body body = (Body)list.get(i);
                if (!(body instanceof GasMolecule) || !this.contains((GasMolecule)body)) continue;
                body.setVelocity(body.getVelocity().scale(1.0 + this.heatSource / 1000.0));
            }
        }
    }

    private boolean contains(GasMolecule gasMolecule) {
        return gasMolecule.getPosition().distanceSq(this.getPosition()) <= (this.getRadius() + gasMolecule.getRadius()) * (this.getRadius() + gasMolecule.getRadius());
    }

    public Rectangle2D getOpening() {
        return this.opening;
    }

    private void setOpening() {
        double d = this.getPosition().getX() + this.oxOffset;
        double d2 = this.getPosition().getX() - this.oxOffset;
        double d3 = this.getPosition().getY() + this.oyOffset;
        this.opening = new Rectangle2D.Double(d2, d3, d - d2, 20.0);
    }

    public void setHeatSource(double d) {
        this.heatSource = d;
        this.changeListenerProxy.heatSourceChanged(new ChangeEvent(this));
    }

    public double getHeatSource() {
        return this.heatSource;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeEventChannel.addListener(changeListener);
    }

    public class ChangeEvent
    extends EventObject {
        public ChangeEvent(Object object) {
            super(object);
        }

        public HotAirBalloon getHotAirBalloon() {
            return (HotAirBalloon)this.getSource();
        }
    }

    public static interface ChangeListener
    extends EventListener {
        public void heatSourceChanged(ChangeEvent var1);
    }
}

