/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.instrumentation;

import edu.colorado.phet.common.phetcommon.view.PhetColorScheme;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetcommon.view.util.RectangleUtils;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsState;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsUtil;
import edu.colorado.phet.idealgas.IdealGasConfig;
import edu.colorado.phet.idealgas.IdealGasResources;
import edu.colorado.phet.idealgas.instrumentation.BarGauge;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class Thermometer
extends PhetGraphic {
    private static Color s_color = PhetColorScheme.RED_COLORBLIND;
    private static Color s_outlineColor = IdealGasConfig.COLOR_SCHEME.thermometerOutline;
    private BarGauge gauge;
    private Ellipse2D.Double bulb;
    private NumberFormat formatter = new DecimalFormat("#0");
    private Point2D location;
    private double scale;
    private double maxScreenLevel;
    private double thickness;
    private double value;
    private Rectangle2D boundingRect;
    private Font font = new PhetFont(1, 10);
    private FontMetrics fontMetrics;
    private double rectBorderThickness = 2.0;
    private RoundRectangle2D.Double readoutRect = new RoundRectangle2D.Double();
    private RoundRectangle2D.Double innerRect = new RoundRectangle2D.Double();
    private BasicStroke rectStroke = new BasicStroke(3.0f);
    private float columnStrokeWidth = 1.5f;
    private BasicStroke columnStroke = new BasicStroke(this.columnStrokeWidth);
    private Color rectColor = Color.yellow;
    private int readoutWidth;
    private float readoutRectStrokeWidth = 0.5f;
    private BasicStroke readoutRectStroke = new BasicStroke(this.readoutRectStrokeWidth);
    private BasicStroke oneStroke;

    public Thermometer(Component component, Point2D.Double double_, double d, double d2, boolean bl, double d3, double d4) {
        super(component);
        this.gauge = new BarGauge(double_, d, s_color, d2, bl, d3, d4);
        this.gauge.setOutlineColor(s_outlineColor);
        this.bulb = new Ellipse2D.Double(double_.x - d2 / 2.0, double_.y + d - d2 * 0.1, d2 * 2.0, d2 * 2.0);
        this.location = double_;
        this.thickness = d2;
        this.scale = d / d4;
        this.maxScreenLevel = d;
        this.fontMetrics = component.getFontMetrics(this.font);
        this.readoutWidth = this.fontMetrics.stringWidth("XXXXXXX");
        this.boundingRect = new Rectangle2D.Double(double_.getX(), double_.getY(), (double)this.readoutWidth + this.rectBorderThickness, d + this.bulb.getHeight());
        super.setIgnoreMouse(true);
    }

    public void setLocation(Point2D.Double double_) {
        this.gauge.setLocation(double_);
        this.location.setLocation(double_);
        int n = this.fontMetrics.stringWidth("XXXXXXX");
        this.boundingRect = new Rectangle2D.Double(double_.getX(), double_.getY(), (double)n + this.rectBorderThickness, this.maxScreenLevel + this.bulb.getHeight());
    }

    public void setValue(double d) {
        this.value = Double.isNaN(d) ? 0.0 : d;
        this.gauge.setLevel(this.value);
    }

    public void paint(Graphics2D graphics2D) {
        GraphicsState graphicsState = new GraphicsState(graphics2D);
        GraphicsUtil.setAntiAliasingOn(graphics2D);
        graphics2D.setFont(this.font);
        int n = this.fontMetrics.getHeight() + this.fontMetrics.getMaxDescent();
        int n2 = this.fontMetrics.stringWidth("XXXXXXX");
        int n3 = Math.max((int)(this.location.getY() + this.maxScreenLevel - (double)n - this.value * this.scale), (int)(this.location.getY() - (double)n));
        this.readoutRect.setRoundRect(this.location.getX() + this.thickness + (double)(this.columnStrokeWidth * 2.0f), (double)n3 - this.rectBorderThickness, (double)n2 + this.rectBorderThickness * 2.0, (double)n + this.rectBorderThickness * 2.0, 4.0, 4.0);
        this.innerRect.setRoundRect(this.location.getX() + this.thickness + (double)(this.columnStrokeWidth * 2.0f) + this.rectBorderThickness, n3, n2, n, 4.0, 4.0);
        graphics2D.setColor(this.rectColor);
        graphics2D.setStroke(this.rectStroke);
        graphics2D.draw(this.readoutRect);
        graphics2D.setColor(s_outlineColor);
        graphics2D.setStroke(this.readoutRectStroke);
        graphics2D.draw(this.readoutRect);
        graphics2D.setColor(this.rectColor);
        graphics2D.fill(this.readoutRect);
        graphics2D.setColor(Color.white);
        graphics2D.fill(this.innerRect);
        this.oneStroke = new BasicStroke(1.0f);
        graphics2D.setStroke(this.oneStroke);
        graphics2D.setColor(Color.black);
        graphics2D.draw(this.innerRect);
        double d = Double.isNaN(this.value) ? 0.0 : this.value / 1000.0;
        String string = this.formatter.format(d) + IdealGasResources.getString("temperature.units.abbreviation");
        graphics2D.setColor(Color.black);
        int n4 = (int)this.innerRect.getMinY() + this.fontMetrics.getHeight();
        graphics2D.drawString(string, (int)this.innerRect.getMaxX() - 5 - this.fontMetrics.stringWidth(string), n4);
        GraphicsUtil.setAntiAliasingOn(graphics2D);
        graphics2D.setStroke(this.columnStroke);
        this.gauge.paint(graphics2D);
        graphics2D.setColor(s_color);
        graphics2D.fill(this.bulb);
        graphics2D.setColor(s_outlineColor);
        graphics2D.draw(this.bulb);
        Rectangle2D.Double double_ = new Rectangle2D.Double(this.gauge.getBounds().getMinX() + (double)this.columnStrokeWidth, this.gauge.getBounds().getMaxY() - 2.0, this.gauge.getBounds().getWidth() - (double)this.columnStrokeWidth, 4.0);
        graphics2D.setColor(s_color);
        graphics2D.fill(double_);
        graphicsState.restoreGraphics();
    }

    protected Rectangle determineBounds() {
        this.boundingRect = new Rectangle2D.Double(this.location.getX(), this.location.getY(), (double)this.readoutWidth + this.rectBorderThickness, this.maxScreenLevel + this.bulb.getHeight());
        double d = Math.min(this.boundingRect.getMinX(), this.readoutRect.getMinX());
        double d2 = Math.min(this.boundingRect.getMinY(), this.readoutRect.getMinY() - (double)this.readoutRectStrokeWidth);
        double d3 = Math.max(this.boundingRect.getMaxX(), this.readoutRect.getMaxX()) - d + (double)(4.0f * this.readoutRectStrokeWidth);
        double d4 = Math.max(this.boundingRect.getMaxY(), this.readoutRect.getMaxY()) - d2;
        this.boundingRect.setRect(d, d2, d3, d4);
        return RectangleUtils.toRectangle(this.boundingRect);
    }
}

