/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.coreadditions;

import edu.colorado.phet.common.phetcommon.model.BaseModel;
import edu.colorado.phet.common.phetcommon.model.ModelElement;
import edu.colorado.phet.common.phetcommon.model.clock.ClockEvent;
import edu.colorado.phet.common.phetcommon.model.clock.ClockListener;
import edu.colorado.phet.common.phetcommon.util.EventChannel;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.idealgas.IdealGasResources;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.EventListener;
import java.util.EventObject;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class StopwatchPanel
extends JPanel
implements ModelElement,
ClockListener {
    private JTextField clockTF = new JTextField();
    private NumberFormat clockFormat = new DecimalFormat("0.00");
    private String[] startStopStr;
    private EventChannel stopwatchEventChannel = new EventChannel(StopwatchListener.class);
    private StopwatchListener stopwatchListenerProxy = (StopwatchListener)this.stopwatchEventChannel.getListenerProxy();
    private JButton resetBtn;
    private double scaleFactor = 1.0;
    private double runningTime = 0.0;
    private boolean isRunning = false;
    private JLabel timeUnitsLabel;
    private JButton startStopBtn;
    private StartStopActionListener startStopActionListener;
    boolean savedResetState;

    public StopwatchPanel(BaseModel baseModel, String string, double d) {
        baseModel.addModelElement(this);
        this.setBackground(new Color(237, 225, 113));
        this.scaleFactor = d;
        this.setBorder(BorderFactory.createRaisedBevelBorder());
        this.clockTF = new JTextField(5);
        Font font = this.clockTF.getFont();
        this.clockTF.setFont(new PhetFont(16, true));
        this.clockTF.setEditable(false);
        this.clockTF.setHorizontalAlignment(4);
        this.resetClock();
        this.startStopStr = new String[2];
        this.startStopStr[0] = IdealGasResources.getString("stopwatch.start");
        this.startStopStr[1] = IdealGasResources.getString("stopwatch.stop");
        this.startStopBtn = new JButton(this.startStopStr[0]);
        this.startStopActionListener = new StartStopActionListener();
        this.startStopBtn.addActionListener(this.startStopActionListener);
        this.resetBtn = new JButton(IdealGasResources.getString("stopwatch.reset"));
        this.resetBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StopwatchPanel.this.resetClock();
            }
        });
        this.setLayout(new FlowLayout());
        this.add(this.startStopBtn);
        this.add(this.resetBtn);
        this.add(this.clockTF);
        this.timeUnitsLabel = new JLabel(string);
        this.add(this.timeUnitsLabel);
        this.resetClock();
    }

    private void resetClock() {
        this.runningTime = 0.0;
        this.displayRunningTime();
        StopwatchEvent stopwatchEvent = new StopwatchEvent(this);
        stopwatchEvent.setReset(true);
        stopwatchEvent.setRunning(false);
        this.stopwatchListenerProxy.reset(stopwatchEvent);
    }

    public void setTimeUnits(String string) {
        this.timeUnitsLabel.setText(string);
    }

    public void reset() {
        this.resetClock();
        if (this.isRunning) {
            this.startStopActionListener.actionPerformed(null);
        }
    }

    private void displayRunningTime() {
        String string = this.clockFormat.format(this.runningTime * this.scaleFactor);
        this.clockTF.setText(string);
    }

    public void clockTicked(ClockEvent clockEvent) {
        String string = this.clockFormat.format(clockEvent.getSimulationTime());
        this.clockTF.setText(string);
    }

    public void clockStarted(ClockEvent clockEvent) {
        this.resetBtn.setEnabled(this.savedResetState);
    }

    public void clockPaused(ClockEvent clockEvent) {
        this.savedResetState = this.resetBtn.isEnabled();
        this.resetBtn.setEnabled(true);
    }

    public void simulationTimeChanged(ClockEvent clockEvent) {
    }

    public void simulationTimeReset(ClockEvent clockEvent) {
    }

    public void stepInTime(double d) {
        if (this.isRunning) {
            this.runningTime += d;
            this.displayRunningTime();
        }
    }

    private class StartStopActionListener
    implements ActionListener {
        int startStopState = 0;

        public void actionPerformed(ActionEvent actionEvent) {
            Serializable serializable;
            if (this.startStopState == 0) {
                serializable = new StopwatchEvent(this);
                serializable.setRunning(true);
                StopwatchPanel.this.stopwatchListenerProxy.start((StopwatchEvent)serializable);
                StopwatchPanel.this.resetBtn.setEnabled(false);
                StopwatchPanel.this.isRunning = true;
            } else {
                serializable = new StopwatchEvent(this);
                serializable.setRunning(false);
                StopwatchPanel.this.stopwatchListenerProxy.stop((StopwatchEvent)serializable);
                StopwatchPanel.this.resetBtn.setEnabled(true);
                StopwatchPanel.this.isRunning = false;
            }
            this.startStopState = (this.startStopState + 1) % 2;
            serializable = StopwatchPanel.this.startStopBtn.getSize();
            StopwatchPanel.this.startStopBtn.setText(StopwatchPanel.this.startStopStr[this.startStopState]);
            Dimension dimension = StopwatchPanel.this.startStopBtn.getSize();
            Dimension dimension2 = new Dimension(Math.max(((Dimension)serializable).width, dimension.width), dimension.height);
            StopwatchPanel.this.startStopBtn.setPreferredSize(dimension2);
        }
    }

    public class StopwatchEvent
    extends EventObject {
        boolean isRunning;
        boolean isReset;

        public StopwatchEvent(Object object) {
            super(object);
            this.isRunning = true;
        }

        public void setRunning(boolean bl) {
            this.isRunning = bl;
        }

        public void setReset(boolean bl) {
            this.isReset = bl;
        }
    }

    public static interface StopwatchListener
    extends EventListener {
        public void start(StopwatchEvent var1);

        public void stop(StopwatchEvent var1);

        public void reset(StopwatchEvent var1);
    }
}

