/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.controller.command;

import edu.colorado.phet.common.phetgraphics.application.PhetGraphicsModule;
import edu.colorado.phet.idealgas.controller.command.AddModelElementCmd;
import edu.colorado.phet.idealgas.model.GasMolecule;
import edu.colorado.phet.idealgas.model.HeavySpecies;
import edu.colorado.phet.idealgas.model.IdealGasModel;
import edu.colorado.phet.idealgas.model.LightSpecies;
import edu.colorado.phet.idealgas.view.GasMoleculeGraphic;
import edu.colorado.phet.idealgas.view.HeavySpeciesGraphic;
import edu.colorado.phet.idealgas.view.LightSpeciesGraphic;
import java.util.Random;

public class PumpMoleculeCmd
extends AddModelElementCmd {
    private GasMolecule molecule;
    private PhetGraphicsModule module;
    private IdealGasModel idealGasModel;
    private static Random random = new Random();

    public PumpMoleculeCmd(IdealGasModel idealGasModel, GasMolecule gasMolecule, PhetGraphicsModule phetGraphicsModule) {
        super(idealGasModel, gasMolecule);
        this.idealGasModel = idealGasModel;
        this.molecule = gasMolecule;
        this.module = phetGraphicsModule;
    }

    public void doIt() {
        super.doIt();
        GasMoleculeGraphic gasMoleculeGraphic = null;
        if (this.molecule instanceof HeavySpecies) {
            gasMoleculeGraphic = new HeavySpeciesGraphic(this.module.getApparatusPanel(), this.molecule);
        } else if (this.molecule instanceof LightSpecies) {
            gasMoleculeGraphic = new LightSpeciesGraphic(this.module.getApparatusPanel(), this.molecule);
        }
        this.idealGasModel.getBox().addContainedBody(this.molecule);
        double d = 1 * (random.nextBoolean() ? 1 : 0);
        this.module.getApparatusPanel().addGraphic(gasMoleculeGraphic, 10.0 + d);
    }
}

