/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.controller;

import edu.colorado.phet.idealgas.controller.GasSource;
import edu.colorado.phet.idealgas.controller.IdealGasModule;
import edu.colorado.phet.idealgas.controller.SpeciesSelectionPanel;
import edu.colorado.phet.idealgas.model.GasMolecule;
import edu.colorado.phet.idealgas.model.HeavySpecies;
import edu.colorado.phet.idealgas.model.LightSpecies;
import edu.colorado.phet.idealgas.model.PressureSensingBox;
import edu.colorado.phet.idealgas.model.Pump;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class PumpControlPanel
extends SpeciesSelectionPanel
implements Pump.Listener {
    private PressureSensingBox box;

    public PumpControlPanel(IdealGasModule idealGasModule, GasSource gasSource, String[] stringArray) {
        super(idealGasModule, stringArray);
        idealGasModule.getPump().addListener(this);
        this.box = idealGasModule.getBox();
    }

    protected void createMolecule(Class clazz) {
        this.getModule().pumpGasMolecules(1, clazz);
    }

    protected void removeMolecule(Class clazz) {
        this.getModule().removeGasMolecule(clazz);
    }

    protected int getHeavySpeciesCnt() {
        return this.getModule().getHeavySpeciesCnt();
    }

    protected int getLightSpeciesCnt() {
        return this.getModule().getLightSpeciesCnt();
    }

    public void moleculesAdded(Pump.MoleculeEvent moleculeEvent) {
        Class clazz = moleculeEvent.getSpecies();
        if (HeavySpecies.class.isAssignableFrom(clazz)) {
            this.getHeavySpinner().setValue(new Integer(this.getModule().getHeavySpeciesCnt()));
        }
        if (LightSpecies.class.isAssignableFrom(clazz)) {
            this.getLightSpinner().setValue(new Integer(this.getModule().getLightSpeciesCnt()));
        }
    }

    public void moleculeAdded(GasMolecule gasMolecule) {
        gasMolecule.addObserver(new MoleculeRemover(gasMolecule));
    }

    private class MoleculeRemover
    implements GasMolecule.Observer {
        GasMolecule molecule;
        boolean isInBox = true;
        SpeciesSelectionPanel.MoleculeCountSpinner spinner;
        Point2D p = new Point2D.Double();
        Rectangle2D b = new Rectangle2D.Double();

        MoleculeRemover(GasMolecule gasMolecule) {
            this.molecule = gasMolecule;
            if (HeavySpecies.class.isAssignableFrom(gasMolecule.getClass())) {
                this.spinner = PumpControlPanel.this.getHeavySpinner();
            }
            if (LightSpecies.class.isAssignableFrom(gasMolecule.getClass())) {
                this.spinner = PumpControlPanel.this.getLightSpinner();
            }
        }

        public void removedFromSystem() {
            this.update();
        }

        public void update() {
            this.b = PumpControlPanel.this.box.getBoundsInternal();
            if (!this.b.contains(this.molecule.getPosition()) && this.isInBox) {
                this.isInBox = false;
                this.spinner.updateValue();
            }
            if (this.b.contains(this.molecule.getPosition()) && !this.isInBox) {
                this.isInBox = true;
                this.spinner.updateValue();
            }
        }
    }
}

