/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.controller;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.idealgas.controller.AdvancedModule;
import edu.colorado.phet.idealgas.controller.GasSource;
import edu.colorado.phet.idealgas.controller.IdealGasModule;
import edu.colorado.phet.idealgas.controller.SpeciesSelectionPanel;
import edu.colorado.phet.idealgas.model.GasMolecule;
import edu.colorado.phet.idealgas.model.HeavySpecies;
import edu.colorado.phet.idealgas.model.IdealGasModel;
import edu.colorado.phet.idealgas.model.Pump;

public class PChemParticleControlPanel
extends SpeciesSelectionPanel
implements Pump.Listener {
    public PChemParticleControlPanel(IdealGasModule idealGasModule, GasSource gasSource, String string, String string2) {
        super(idealGasModule);
        ((IdealGasModel)this.getModule().getModel()).addObserver(new SimpleObserver(){

            public void update() {
                int n = PChemParticleControlPanel.this.getModule().getIdealGasModel().getHeavySpeciesCnt();
                PChemParticleControlPanel.this.getHeavySpinner().setValue(new Integer(n));
            }
        });
        ((IdealGasModel)this.getModule().getModel()).addObserver(new SimpleObserver(){

            public void update() {
                int n = PChemParticleControlPanel.this.getModule().getIdealGasModel().getLightSpeciesCnt();
                PChemParticleControlPanel.this.getLightSpinner().setValue(new Integer(n));
            }
        });
        this.setHeavySpeciesLabelText(string);
        this.setLightSpeciesLabelText(string2);
        this.setHeavySpeciesLabelColor(AdvancedModule.COLOR_A);
        this.setLightSpeciesLabelColor(AdvancedModule.COLOR_B);
        this.repaint();
    }

    protected void createMolecule(Class clazz) {
        this.getModule().pumpGasMolecules(1, clazz);
    }

    protected void removeMolecule(Class clazz) {
        this.getModule().removeGasMolecule(clazz);
    }

    protected int getHeavySpeciesCnt() {
        return this.getModule().getIdealGasModel().getHeavySpeciesCnt();
    }

    protected int getLightSpeciesCnt() {
        return this.getModule().getIdealGasModel().getLightSpeciesCnt();
    }

    public void moleculesAdded(Pump.MoleculeEvent moleculeEvent) {
        Class clazz = moleculeEvent.getSpecies();
        if (HeavySpecies.class.isAssignableFrom(clazz)) {
            int n = (Integer)this.getHeavySpinner().getValue();
            this.getHeavySpinner().setValue(new Integer(n + moleculeEvent.getNumMolecules()));
        }
    }

    public void moleculeAdded(GasMolecule gasMolecule) {
    }
}

