/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.controller;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.view.ControlPanel;
import edu.colorado.phet.idealgas.IdealGasResources;
import edu.colorado.phet.idealgas.collision.SphereHotAirBalloonExpert;
import edu.colorado.phet.idealgas.controller.HotAirBalloonControlPanel;
import edu.colorado.phet.idealgas.controller.IdealGasControlPanel;
import edu.colorado.phet.idealgas.controller.IdealGasModule;
import edu.colorado.phet.idealgas.model.BoxMustContainParticle;
import edu.colorado.phet.idealgas.model.HotAirBalloon;
import edu.colorado.phet.idealgas.model.IdealGasClock;
import edu.colorado.phet.idealgas.model.PressureSensingBox;
import edu.colorado.phet.idealgas.model.Pump;
import edu.colorado.phet.idealgas.view.HotAirBalloonGraphic;
import java.awt.geom.Point2D;

public class HotAirBalloonModule
extends IdealGasModule {
    private HotAirBalloon balloon;
    private double initRadius;
    private double initX;
    private double initY;
    private int defaultGravity = 10;

    public HotAirBalloonModule(IdealGasClock idealGasClock) {
        super(idealGasClock, IdealGasResources.getString("ModuleTitle.HotAirBalloon"));
        this.getIdealGasModel().addCollisionExpert(new SphereHotAirBalloonExpert(this.getIdealGasModel(), idealGasClock.getDt()));
        PressureSensingBox pressureSensingBox = this.getIdealGasModel().getBox();
        this.initRadius = 50.0;
        this.initX = pressureSensingBox.getMinX() + pressureSensingBox.getWidth() / 2.0;
        this.initY = pressureSensingBox.getMaxY() - this.initRadius - 100.0;
        this.balloon = new HotAirBalloon(new Point2D.Double(this.initX, this.initY), new MutableVector2D(0.0, 0.0), new MutableVector2D(0.0, 0.0), 200.0, this.initRadius, 60.0, this.getIdealGasModel());
        pressureSensingBox.setMinimumWidth(this.balloon.getRadius() * 3.0);
        this.getIdealGasModel().addModelElement(this.balloon);
        BoxMustContainParticle boxMustContainParticle = new BoxMustContainParticle(pressureSensingBox, this.balloon, this.getIdealGasModel());
        this.balloon.addConstraint(boxMustContainParticle);
        HotAirBalloonGraphic hotAirBalloonGraphic = new HotAirBalloonGraphic(this.getApparatusPanel(), this.balloon);
        this.addGraphic(hotAirBalloonGraphic, 20.0);
        IdealGasControlPanel idealGasControlPanel = new IdealGasControlPanel(this);
        idealGasControlPanel.addParticleControl(new HotAirBalloonControlPanel(this.balloon));
        this.setControlPanel(new ControlPanel(this));
        this.getControlPanel().add(idealGasControlPanel);
        this.setGravity(this.defaultGravity);
    }

    protected Pump.PumpingEnergyStrategy getPumpingEnergyStrategy() {
        return new Pump.FixedEnergyStrategy();
    }

    public void reset() {
        super.reset();
        this.balloon.setHeatSource(0.0);
    }

    protected void resetChamber() {
        super.resetChamber();
        this.balloon.setPosition(new Point2D.Double(this.initX, this.initY));
    }
}

