/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.controller;

import edu.colorado.phet.idealgas.IdealGasResources;
import edu.colorado.phet.idealgas.controller.AdvancedModule;
import edu.colorado.phet.idealgas.controller.IdealGasModule;
import edu.colorado.phet.idealgas.controller.MeasurementToolsControls;
import edu.colorado.phet.idealgas.controller.PChemParticleControlPanel;
import edu.colorado.phet.idealgas.model.Gravity;
import edu.colorado.phet.idealgas.model.IdealGasModel;
import edu.colorado.phet.idealgas.model.Pump;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class AdvancedIdealGasControlPanel
extends JPanel
implements Gravity.ChangeListener {
    private NumberFormat gravityFormat = NumberFormat.getInstance();
    private JSlider gravitySlider;
    private IdealGasModule module;
    private IdealGasModel idealGasModel;
    private GridBagConstraints gbc;
    private JPanel particleControlsPanel;
    private JPanel buttonPanel;
    private GridBagConstraints particleControlsGbc;
    private String leftParticlesLabel;
    private String rightParticlesLabel;

    public AdvancedIdealGasControlPanel(IdealGasModule idealGasModule, String string, String string2) {
        this.module = idealGasModule;
        this.leftParticlesLabel = string;
        this.rightParticlesLabel = string2;
        this.idealGasModel = (IdealGasModel)idealGasModule.getModel();
        this.idealGasModel.getGravity().addListener(this);
        this.init();
    }

    private void init() {
        this.makeButtonPanel();
        this.makeParticlesControls();
        this.setLayout(new GridBagLayout());
        this.gbc = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
        this.add((Component)this.particleControlsPanel, this.gbc);
        this.add((Component)this.buttonPanel, this.gbc);
        Border border = BorderFactory.createEtchedBorder();
        this.setBorder(border);
    }

    private void makeParticlesControls() {
        this.particleControlsPanel = new JPanel(new GridBagLayout());
        this.particleControlsGbc = new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0);
        PChemParticleControlPanel pChemParticleControlPanel = new PChemParticleControlPanel(this.module, this.module.getPump(), this.leftParticlesLabel, this.rightParticlesLabel);
        pChemParticleControlPanel.setBorder(new TitledBorder(IdealGasResources.getString("IdealGasControlPanel.Particles_In_Chamber")));
        this.particleControlsPanel.add((Component)pChemParticleControlPanel, this.particleControlsGbc);
        JLabel jLabel = new JLabel(IdealGasResources.getString("AdvancedControlPanel.Particle_Temperature"));
        this.particleControlsGbc.insets = new Insets(10, 10, 10, 10);
        this.particleControlsGbc.gridwidth = 1;
        this.particleControlsGbc.gridx = 0;
        this.particleControlsGbc.gridy = 1;
        this.particleControlsGbc.anchor = 13;
        this.particleControlsPanel.add((Component)jLabel, this.particleControlsGbc);
        final JSpinner jSpinner = new JSpinner(new SpinnerNumberModel(300.0, 50.0, 1000.0, 1.0));
        this.particleControlsGbc.gridx = 1;
        this.particleControlsGbc.anchor = 17;
        this.particleControlsPanel.add((Component)jSpinner, this.particleControlsGbc);
        jSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                double d = (Double)jSpinner.getValue() * 20.0 * 2.5;
                AdvancedIdealGasControlPanel.this.setPumpTemperatures(d);
            }
        });
        double d = (Double)jSpinner.getValue() * 20.0 * 2.5;
        this.setPumpTemperatures(d);
    }

    private void setPumpTemperatures(double d) {
        System.out.println("temperature = " + d);
        Pump[] pumpArray = ((AdvancedModule)this.getModule()).getPumps();
        for (int i = 0; i < pumpArray.length; ++i) {
            if (pumpArray[i] == null) continue;
            pumpArray[i].setPumpingEnergyStrategy(new Pump.FixedEnergyStrategy(d));
        }
    }

    private void makeButtonPanel() {
        JButton jButton = new JButton(IdealGasResources.getString("IdealGasControlPanel.Reset"));
        jButton.setBackground(new Color(180, 255, 180));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedIdealGasControlPanel.this.module.reset();
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(2, 1));
        jPanel.add(new MeasurementToolsControls.SpeciesMonitorControl(this.module));
        jPanel.add(new MeasurementToolsControls.HistogramControlPanel(this.module));
        this.buttonPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0);
        this.buttonPanel.add((Component)jPanel, gridBagConstraints);
        this.buttonPanel.add((Component)jButton, gridBagConstraints);
        this.buttonPanel.revalidate();
    }

    protected IdealGasModule getModule() {
        return this.module;
    }

    public void gravityChanged(Gravity.ChangeEvent changeEvent) {
        this.gravitySlider.setValue((int)changeEvent.getGravity().getAmt());
    }
}

