/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.collision;

import edu.colorado.phet.idealgas.collision.CollidableBody;
import edu.colorado.phet.idealgas.collision.ContactDetector;
import edu.colorado.phet.idealgas.collision.SolidSphere;
import edu.colorado.phet.idealgas.collision.SphericalBody;
import java.awt.geom.Point2D;

public class SphereSphereContactDetector
implements ContactDetector {
    private Point2D tempPt = new Point2D.Double();

    public boolean applies(CollidableBody collidableBody, CollidableBody collidableBody2) {
        return collidableBody instanceof SolidSphere && collidableBody2 instanceof SolidSphere;
    }

    public boolean areInContact(CollidableBody collidableBody, CollidableBody collidableBody2) {
        SphericalBody sphericalBody = (SphericalBody)collidableBody;
        SphericalBody sphericalBody2 = (SphericalBody)collidableBody2;
        if (this.boundingBoxesOverlap(sphericalBody, sphericalBody2)) {
            return this.spheresOverlap(sphericalBody, sphericalBody2);
        }
        return false;
    }

    private boolean spheresOverlap(SphericalBody sphericalBody, SphericalBody sphericalBody2) {
        this.tempPt.setLocation(sphericalBody.getPosition());
        double d = this.tempPt.distance(sphericalBody2.getPosition());
        return d <= sphericalBody.getRadius() + sphericalBody2.getRadius();
    }

    private boolean boundingBoxesOverlap(SphericalBody sphericalBody, SphericalBody sphericalBody2) {
        return Math.abs(sphericalBody.getPosition().getX() - sphericalBody2.getPosition().getX()) <= sphericalBody.getRadius() + sphericalBody2.getRadius() && Math.abs(sphericalBody.getPosition().getY() - sphericalBody2.getPosition().getY()) <= sphericalBody.getRadius() + sphericalBody2.getRadius();
    }
}

