/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.collision;

import edu.colorado.phet.idealgas.collision.CollidableBody;
import edu.colorado.phet.idealgas.collision.CollisionExpert;
import edu.colorado.phet.idealgas.collision.ContactDetector;
import edu.colorado.phet.idealgas.collision.SphereBoxCollision;
import edu.colorado.phet.idealgas.collision.SphericalBody;
import edu.colorado.phet.idealgas.model.Box2D;
import edu.colorado.phet.idealgas.model.GasMolecule;
import edu.colorado.phet.idealgas.model.IdealGasModel;

public class SphereBoxExpert
implements CollisionExpert,
ContactDetector {
    private IdealGasModel model;
    static int cnt = 0;

    public SphereBoxExpert(IdealGasModel idealGasModel) {
        this.model = idealGasModel;
    }

    public boolean detectAndDoCollision(CollidableBody collidableBody, CollidableBody collidableBody2) {
        boolean bl = false;
        if (this.applies(collidableBody, collidableBody2) && this.areInContact(collidableBody, collidableBody2)) {
            Box2D box2D;
            SphericalBody sphericalBody = collidableBody instanceof SphericalBody ? (SphericalBody)collidableBody : (SphericalBody)collidableBody2;
            Box2D box2D2 = box2D = collidableBody instanceof Box2D ? (Box2D)collidableBody : (Box2D)collidableBody2;
            if (!(sphericalBody instanceof GasMolecule) || !box2D.containsBody(sphericalBody)) {
                // empty if block
            }
            if (!box2D.isInOpening(sphericalBody)) {
                double d = sphericalBody.getPosition().getX();
                double d2 = sphericalBody.getPosition().getY();
                double d3 = sphericalBody.getPositionPrev().getX();
                double d4 = sphericalBody.getPositionPrev().getY();
                double d5 = sphericalBody.getRadius();
                boolean bl2 = false;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                if (!(sphericalBody instanceof GasMolecule) || box2D.containsBody(sphericalBody)) {
                    bl2 = d - d5 <= box2D.getMinX();
                    bl3 = d + d5 >= box2D.getMaxX();
                    bl4 = d2 - d5 <= box2D.getMinY();
                    boolean bl6 = bl5 = d2 + d5 >= box2D.getMaxY();
                }
                if (!(bl2 && bl3 || bl4 && bl5)) {
                    SphereBoxCollision sphereBoxCollision = new SphereBoxCollision(sphericalBody, box2D, this.model);
                    sphereBoxCollision.collide();
                }
            }
        }
        return bl;
    }

    public boolean applies(CollidableBody collidableBody, CollidableBody collidableBody2) {
        return collidableBody instanceof SphericalBody && collidableBody2 instanceof Box2D || collidableBody instanceof Box2D && collidableBody2 instanceof SphericalBody;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean areInContact(CollidableBody collidableBody, CollidableBody collidableBody2) {
        double d;
        SphericalBody sphericalBody;
        boolean bl = false;
        Box2D box2D = null;
        if (collidableBody instanceof Box2D) {
            box2D = (Box2D)collidableBody;
            if (!(collidableBody2 instanceof SphericalBody)) throw new RuntimeException("bad args");
            sphericalBody = (SphericalBody)collidableBody2;
        } else {
            if (!(collidableBody2 instanceof Box2D)) throw new RuntimeException("bad args");
            box2D = (Box2D)collidableBody2;
            if (!(collidableBody instanceof SphericalBody)) throw new RuntimeException("bad args");
            sphericalBody = (SphericalBody)collidableBody;
        }
        double d2 = sphericalBody.getCenter().getX() - sphericalBody.getRadius() - box2D.getMinX();
        if (d2 <= 0.0) {
            bl = true;
        }
        if ((d2 = sphericalBody.getCenter().getX() + sphericalBody.getRadius() - box2D.getMaxX()) >= 0.0 && sphericalBody.getVelocity().getX() > 0.0) {
            bl = true;
        }
        if ((d = sphericalBody.getCenter().getY() - sphericalBody.getRadius() - box2D.getMinY()) <= 0.0 && sphericalBody.getVelocity().getY() < 0.0) {
            bl = true;
        }
        if (!((d = sphericalBody.getCenter().getY() + sphericalBody.getRadius() - box2D.getMaxY()) >= 0.0)) return bl;
        if (!(sphericalBody.getVelocity().getY() > 0.0)) return bl;
        return true;
    }
}

