/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.common.phetcommon.resources;

import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PhetVersion {
    private static final SimpleDateFormat FORMAT_TIMESTAMP = new SimpleDateFormat("MMM d, yyyy");
    private final String major;
    private final String minor;
    private final String dev;
    private final String revision;
    private final String timestamp;

    public PhetVersion(String string, String string2, String string3, String string4, String string5) {
        this.major = PhetVersion.cleanup(string);
        this.minor = PhetVersion.cleanup(string2);
        this.dev = PhetVersion.cleanup(string3);
        this.revision = PhetVersion.cleanup(string4);
        this.timestamp = PhetVersion.cleanup(string5);
    }

    public String getMajor() {
        return this.major;
    }

    public int getMajorAsInt() {
        return PhetVersion.getAsInt(this.getMajor());
    }

    public String getMinor() {
        return this.minor;
    }

    public String getDev() {
        return this.dev;
    }

    public int getDevAsInt() {
        return PhetVersion.getAsInt(this.getDev());
    }

    public String getRevision() {
        return this.revision;
    }

    public int getRevisionAsInt() {
        return PhetVersion.getAsInt(this.getRevision());
    }

    private boolean isDevVersion() {
        return this.getDevAsInt() != 0;
    }

    public String formatForTitleBar() {
        return this.isDevVersion() ? this.formatMajorMinorDev() : this.formatMajorMinor();
    }

    public String formatForAboutDialog() {
        Object[] objectArray = new Object[]{this.major, this.minor, this.dev, this.revision, this.formatTimestamp()};
        return MessageFormat.format("{0}.{1}.{2} ({3})", objectArray);
    }

    public String formatTimestamp() {
        long l;
        String string = "?";
        if (this.timestamp != null && this.timestamp.length() > 0 && (l = this.getTimestampSeconds()) > 0L) {
            Date date = new Date(l * 1000L);
            string = FORMAT_TIMESTAMP.format(date);
        }
        return string;
    }

    public String formatMajorMinorDev() {
        Object[] objectArray = new Object[]{this.major, this.minor, this.dev};
        return MessageFormat.format("{0}.{1}.{2}", objectArray);
    }

    public String formatMajorMinor() {
        Object[] objectArray = new Object[]{this.major, this.minor};
        return MessageFormat.format("{0}.{1}", objectArray);
    }

    public String toString() {
        return this.formatForAboutDialog();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PhetVersion phetVersion = (PhetVersion)object;
        return this.dev.equals(phetVersion.dev) && this.major.equals(phetVersion.major) && this.minor.equals(phetVersion.minor) && this.revision.equals(phetVersion.revision);
    }

    public int hashCode() {
        int n = this.major.hashCode();
        n = 31 * n + this.minor.hashCode();
        n = 31 * n + this.dev.hashCode();
        n = 31 * n + this.revision.hashCode();
        return n;
    }

    private static String cleanup(String string) {
        String string2 = string;
        if (string == null) {
            string2 = "?";
        }
        return string2;
    }

    private static int getAsInt(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            n = -1;
        }
        return n;
    }

    public boolean isGreaterThan(PhetVersion phetVersion) {
        return this.getRevisionAsInt() > phetVersion.getRevisionAsInt();
    }

    public long getTimestampSeconds() {
        long l = 0L;
        try {
            l = Long.parseLong(this.timestamp);
        }
        catch (NumberFormatException numberFormatException) {
            System.err.println("PhetVersion.getTimestampSeconds: timestamp is invalid, ignoring: " + this.timestamp);
            l = 0L;
        }
        return l;
    }
}

