/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.view.monitors;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.idealgas.IdealGasConfig;
import edu.colorado.phet.idealgas.IdealGasResources;
import edu.colorado.phet.idealgas.coreadditions.ScalarObservable;
import edu.colorado.phet.idealgas.instrumentation.DialGauge;
import edu.colorado.phet.idealgas.model.PressureSensingBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.DecimalFormat;

public class PressureDialGauge
extends PhetShapeGraphic {
    private PressureSensingBox box;
    private double radius = 50.0;
    private double stemLength = 15.0;
    private double stemThickness = 10.0;
    private DialGauge pressureGauge;
    private Point2D.Double center;
    private Rectangle2D.Double stem;
    private Font font = new PhetFont(1, 10);
    private DecimalFormat numberFormat;
    private long updatePeriod = 200L;

    public PressureDialGauge(PressureSensingBox pressureSensingBox, Component component, Point point) {
        super(component);
        this.box = pressureSensingBox;
        this.center = new Point2D.Double(point.getX() + this.radius + this.stemLength, point.getY());
        this.numberFormat = new DecimalFormat("#0.00");
        this.pressureGauge = new DialGauge(new ObservablePressureBox(this.updatePeriod), component, this.center.getX(), this.center.getY(), this.radius * 2.0, 0.0, 6.0, IdealGasResources.getString("pressure-gauge.title"), IdealGasResources.getString("pressure-gauge.units"), this.font, this.numberFormat);
        this.pressureGauge.setBackground(new Color(230, 255, 230));
        this.stem = new Rectangle2D.Double(pressureSensingBox.getMaxX(), this.center.getY() - this.stemThickness / 2.0, this.stemLength, this.stemThickness);
        super.setIgnoreMouse(true);
    }

    public void paint(Graphics2D graphics2D) {
        this.saveGraphicsState(graphics2D);
        graphics2D.setColor(IdealGasConfig.COLOR_SCHEME.pressureGaugeNeckColor);
        graphics2D.fill(this.stem);
        this.pressureGauge.paint(graphics2D);
        this.restoreGraphicsState();
    }

    protected Rectangle determineBounds() {
        return this.pressureGauge.getBounds();
    }

    private class ObservablePressureBox
    extends ScalarObservable
    implements SimpleObserver {
        private long notificationPeriod = 0L;
        private long lastNotificationTime;

        public ObservablePressureBox(long l) {
            this.notificationPeriod = l;
            PressureDialGauge.this.box.addObserver(this);
        }

        public double getValue() {
            return PressureDialGauge.this.box.getPressure();
        }

        public void update() {
            long l = System.currentTimeMillis();
            if (l - this.lastNotificationTime > this.notificationPeriod) {
                this.notifyObservers();
                this.lastNotificationTime = l;
            }
        }
    }
}

