/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.view;

import edu.colorado.phet.common.phetcommon.util.SimpleObserver;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetShapeGraphic;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsUtil;
import edu.colorado.phet.idealgas.model.HollowSphere;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;

public class HollowSphereGraphic
extends PhetShapeGraphic
implements SimpleObserver {
    private static Stroke s_defaultStroke = new BasicStroke(2.0f);
    private static Color s_defaultColor = Color.GREEN;
    private static float s_sphereOpacity = 0.25f;
    private Ellipse2D.Double rep;
    private HollowSphere sphere;

    public HollowSphereGraphic(Component component, HollowSphere hollowSphere) {
        super(component, null, s_defaultColor, s_defaultStroke, s_defaultColor);
        this.sphere = hollowSphere;
        hollowSphere.addObserver(this);
        this.rep = new Ellipse2D.Double();
        this.setShape(this.rep);
        this.setStroke(s_defaultStroke);
        this.setColor(s_defaultColor);
        this.update();
        super.setIgnoreMouse(true);
    }

    public void update() {
        this.rep.setFrameFromCenter(this.sphere.getPosition().getX(), this.sphere.getPosition().getY(), this.sphere.getPosition().getX() + this.sphere.getRadius(), this.sphere.getPosition().getY() + this.sphere.getRadius());
        this.setShapeDirty();
        this.repaint();
    }

    public void paint(Graphics2D graphics2D) {
        this.saveGraphicsState(graphics2D);
        GraphicsUtil.setAntiAliasingOn(graphics2D);
        graphics2D.setStroke(s_defaultStroke);
        graphics2D.setColor(s_defaultColor);
        graphics2D.draw(this.rep);
        GraphicsUtil.setAlpha(graphics2D, s_sphereOpacity);
        graphics2D.fill(this.rep);
        if (this.sphere.contactPt != null) {
            GraphicsUtil.setAlpha(graphics2D, 1.0);
            graphics2D.setColor(Color.red);
            graphics2D.fillArc((int)this.sphere.contactPt.getX() - 1, (int)this.sphere.contactPt.getY() - 1, 2, 2, 0, 360);
        }
        this.restoreGraphicsState();
    }
}

