/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.view;

import edu.colorado.phet.common.phetcommon.view.util.PhetFont;
import edu.colorado.phet.common.phetgraphics.view.util.GraphicsState;
import edu.colorado.phet.idealgas.collision.Wall;
import edu.colorado.phet.idealgas.view.WallGraphic;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Stroke;

public class GraduatedWallGraphic
extends WallGraphic {
    private int minorTickInterval = 5;
    private int majorTickInterval = 25;
    private Color backgroundColor = new Color(230, 230, 40);
    private Stroke minorTickStroke = new BasicStroke(1.0f);
    private Stroke majorTickStroke = new BasicStroke(1.0f);
    private Font graduationFont = new PhetFont(0, 10);
    private Wall wall;

    public GraduatedWallGraphic(Wall wall, Component component, Paint paint, Paint paint2, int n) {
        super(wall, component, paint, paint2, n);
        this.wall = wall;
        this.setCursor(new Cursor(8));
    }

    public boolean contains(int n, int n2) {
        return this.wall.getBounds().contains(n, n2) && Math.abs((double)n2 - this.wall.getBounds().getMinY()) < 5.0;
    }

    public void paint(Graphics2D graphics2D) {
        Rectangle rectangle = this.getShape().getBounds();
        GraphicsState graphicsState = new GraphicsState(graphics2D);
        super.paint(graphics2D);
        graphics2D.setColor(this.backgroundColor);
        graphics2D.fill(rectangle);
        graphics2D.setColor(Color.black);
        int n = 0;
        while ((double)n < rectangle.getHeight()) {
            graphics2D.setStroke(this.minorTickStroke);
            graphics2D.drawLine((int)rectangle.getMinX(), (int)rectangle.getMaxY() - n, (int)rectangle.getMinX() + 3, (int)rectangle.getMaxY() - n);
            graphics2D.drawLine((int)rectangle.getMaxX(), (int)rectangle.getMaxY() - n, (int)rectangle.getMaxX() - 3, (int)rectangle.getMaxY() - n);
            n += this.minorTickInterval;
        }
        n = 0;
        while ((double)n < rectangle.getHeight()) {
            graphics2D.setStroke(this.majorTickStroke);
            graphics2D.drawLine((int)rectangle.getMinX(), (int)rectangle.getMaxY() - n, (int)rectangle.getMinX() + 5, (int)rectangle.getMaxY() - n);
            graphics2D.drawLine((int)rectangle.getMaxX(), (int)rectangle.getMaxY() - n, (int)rectangle.getMaxX() - 5, (int)rectangle.getMaxY() - n);
            if (n > 0) {
                String string = Integer.toString(n / (this.majorTickInterval / this.minorTickInterval));
                graphics2D.setFont(this.graduationFont);
                FontMetrics fontMetrics = graphics2D.getFontMetrics();
                int n2 = fontMetrics.stringWidth(string) / 2;
                int n3 = fontMetrics.getAscent() / 2;
                graphics2D.drawString(string, (int)(rectangle.getMinX() + rectangle.getWidth() / 2.0 - (double)n2), (int)rectangle.getMaxY() - n + n3);
            }
            n += this.majorTickInterval;
        }
        graphics2D.setPaint(this.getBorder());
        graphics2D.draw(rectangle);
        graphicsState.restoreGraphics();
    }
}

