/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.view;

import edu.colorado.phet.common.phetgraphics.view.ApparatusPanel;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetImageGraphic;
import edu.colorado.phet.idealgas.model.GasMolecule;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public abstract class GasMoleculeGraphic
extends PhetImageGraphic
implements GasMolecule.Observer {
    private GasMolecule molecule;
    private ApparatusPanel apparatusPanel;
    private static Color s_color;
    private AffineTransform scaleAtx = new AffineTransform();
    private BufferedImage baseImage;
    private static Dimension dim;

    public GasMoleculeGraphic(ApparatusPanel apparatusPanel, BufferedImage bufferedImage, GasMolecule gasMolecule) {
        super(apparatusPanel, bufferedImage);
        this.apparatusPanel = apparatusPanel;
        this.molecule = gasMolecule;
        this.baseImage = bufferedImage;
        gasMolecule.addObserver(this);
        super.setIgnoreMouse(true);
        this.update();
        if (dim == null) {
            dim = apparatusPanel.getSize();
        }
    }

    public void paint(Graphics2D graphics2D) {
        AffineTransform affineTransform = this.getNetTransform();
        graphics2D.drawImage((Image)this.getImage(), (int)affineTransform.getTranslateX(), (int)affineTransform.getTranslateY(), null);
    }

    public void update() {
        super.setLocation((int)(this.molecule.getCM().getX() - this.molecule.getRadius()), (int)(this.molecule.getCM().getY() - this.molecule.getRadius()));
    }

    public void removedFromSystem() {
        this.apparatusPanel.removeGraphic(this);
        this.update();
    }

    public static void setColor(Color color) {
        s_color = color;
    }

    static {
        dim = null;
    }
}

