/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.model;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.common.phetcommon.util.SimpleObservable;
import edu.colorado.phet.common.phetgraphics.application.PhetGraphicsModule;
import edu.colorado.phet.idealgas.controller.GasSource;
import edu.colorado.phet.idealgas.controller.command.PumpMoleculeCmd;
import edu.colorado.phet.idealgas.model.Box2D;
import edu.colorado.phet.idealgas.model.GasMolecule;
import edu.colorado.phet.idealgas.model.HeavySpecies;
import edu.colorado.phet.idealgas.model.IdealGasModel;
import edu.colorado.phet.idealgas.model.LightSpecies;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.EventObject;

public class Pump
extends SimpleObservable
implements GasSource {
    private static float s_intakePortOffsetY = 1.0f;
    private IdealGasModel model;
    private PhetGraphicsModule module;
    private Class currentGasSpecies = HeavySpecies.class;
    private PumpingEnergyStrategy pumpingEnergyStrategy;
    private Box2D box;
    private double minTheta = 2.356194490192345;
    private double maxTheta = 3.9269908169872414;
    private ArrayList listeners = new ArrayList();

    public Pump(PhetGraphicsModule phetGraphicsModule, Box2D box2D, PumpingEnergyStrategy pumpingEnergyStrategy) {
        this.pumpingEnergyStrategy = pumpingEnergyStrategy;
        if (box2D == null) {
            throw new RuntimeException("box cannot be null");
        }
        this.module = phetGraphicsModule;
        this.model = (IdealGasModel)phetGraphicsModule.getModel();
        this.box = box2D;
    }

    public void pump(int n) {
        this.pump(n, this.currentGasSpecies);
    }

    public void pump(int n, Class clazz) {
        for (int i = 0; i < n; ++i) {
            GasMolecule gasMolecule = this.pumpGasMolecule(clazz);
            for (int j = 0; j < this.listeners.size(); ++j) {
                Listener listener = (Listener)this.listeners.get(j);
                listener.moleculeAdded(gasMolecule);
            }
        }
        MoleculeEvent moleculeEvent = new MoleculeEvent(this, clazz, n);
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.moleculesAdded(moleculeEvent);
        }
    }

    public void pump(int n, Class clazz, Point2D point2D) {
        for (int i = 0; i < n; ++i) {
            GasMolecule gasMolecule = this.pumpGasMolecule(clazz);
            gasMolecule.setPosition(point2D);
            for (int j = 0; j < this.listeners.size(); ++j) {
                Listener listener = (Listener)this.listeners.get(j);
                listener.moleculeAdded(gasMolecule);
            }
        }
        MoleculeEvent moleculeEvent = new MoleculeEvent(this, clazz, n);
        for (int i = 0; i < this.listeners.size(); ++i) {
            Listener listener = (Listener)this.listeners.get(i);
            listener.moleculesAdded(moleculeEvent);
        }
    }

    protected GasMolecule pumpGasMolecule(Class clazz) {
        double d = this.pumpingEnergyStrategy.getMoleculeEnergy();
        GasMolecule gasMolecule = this.createMolecule(clazz, d);
        new PumpMoleculeCmd(this.model, gasMolecule, this.module).doIt();
        this.notifyObservers();
        return gasMolecule;
    }

    public void setCurrentGasSpecies(Class clazz) {
        this.currentGasSpecies = clazz;
    }

    public void setPumpingEnergyStrategy(PumpingEnergyStrategy pumpingEnergyStrategy) {
        this.pumpingEnergyStrategy = pumpingEnergyStrategy;
    }

    public void setDispersionAngle(double d, double d2) {
        this.minTheta = d;
        this.maxTheta = d2;
    }

    private GasMolecule createMolecule(Class clazz, double d) {
        s_intakePortOffsetY *= -1.0f;
        GasMolecule gasMolecule = null;
        if (clazz == LightSpecies.class) {
            gasMolecule = new LightSpecies(new Point2D.Double(460.0, 305.0f + s_intakePortOffsetY * 5.0f), new MutableVector2D(0.0, 0.0), new MutableVector2D(0.0, 0.0));
        } else if (clazz == HeavySpecies.class) {
            gasMolecule = new HeavySpecies(new Point2D.Double(460.0, 305.0f + s_intakePortOffsetY * 5.0f), new MutableVector2D(0.0, 0.0), new MutableVector2D(0.0, 0.0));
        } else {
            throw new RuntimeException("No gas species set in application");
        }
        double d2 = 2.0 * d / gasMolecule.getMass();
        if (d2 <= 0.0) {
            System.out.println("vSq <= 0 in PumpMoleculeCmd.createMolecule");
        }
        float f = d2 > 0.0 ? (float)Math.sqrt(d2) : 10.0f;
        double d3 = Math.random() * (this.maxTheta - this.minTheta) + this.minTheta;
        float f2 = f * (float)Math.cos(d3);
        float f3 = f * (float)Math.sin(d3);
        gasMolecule.setVelocity(f2, f3);
        gasMolecule.setVelocity(f2, f3);
        return gasMolecule;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public static class ConstantEnergyStrategy
    implements PumpingEnergyStrategy {
        private IdealGasModel model;

        public ConstantEnergyStrategy(IdealGasModel idealGasModel) {
            this.model = idealGasModel;
        }

        public double getMoleculeEnergy() {
            double d = 0.0;
            d = this.model.getNumMolecules() > 0 ? this.model.getAverageGasEnergy() : 15000.0;
            return d;
        }
    }

    public static class FixedEnergyStrategy
    implements PumpingEnergyStrategy {
        private double fixedEnergy = 15000.0;

        public FixedEnergyStrategy() {
        }

        public FixedEnergyStrategy(double d) {
            this.fixedEnergy = d;
        }

        public double getMoleculeEnergy() {
            return this.fixedEnergy;
        }
    }

    public static interface Listener
    extends EventListener {
        public void moleculesAdded(MoleculeEvent var1);

        public void moleculeAdded(GasMolecule var1);
    }

    public class MoleculeEvent
    extends EventObject {
        private Class species;
        private int numMolecules;

        public MoleculeEvent(Object object, Class clazz, int n) {
            super(object);
            this.species = clazz;
            this.numMolecules = n;
        }

        public Class getSpecies() {
            return this.species;
        }

        public int getNumMolecules() {
            return this.numMolecules;
        }
    }

    public static interface PumpingEnergyStrategy {
        public double getMoleculeEnergy();
    }
}

