/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.controller;

import edu.colorado.phet.idealgas.IdealGasResources;
import edu.colorado.phet.idealgas.controller.IdealGasModule;
import edu.colorado.phet.idealgas.controller.InputTemperatureControlPanel;
import edu.colorado.phet.idealgas.controller.MeasurementToolsControls;
import edu.colorado.phet.idealgas.coreadditions.ToggleButton;
import edu.colorado.phet.idealgas.model.Pump;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;

public class ToolPanel
extends JPanel {
    JPanel toolsPanel = new JPanel(new GridBagLayout());
    private JComponent button;
    private Insets panelInsets = new Insets(0, 0, 0, 0);
    private Insets buttonInsets = new Insets(10, 0, 0, 0);
    private GridBagConstraints topLevelGbc = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, this.panelInsets, 0, 0);
    private GridBagConstraints toolsPanelInternalGbc = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 0, this.panelInsets, 0, 0);
    private GridBagConstraints advToolsPanelInternalGbc = new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 10, 0, 10), 0, 0);
    private JPanel advToolPanel;

    public ToolPanel(final IdealGasModule idealGasModule) {
        this.setLayout(new GridBagLayout());
        this.setBorder(new TitledBorder(IdealGasResources.getString("IdealGasControlPanel.Tools_and_options")));
        this.button = new ToggleButton(IdealGasResources.getString("IdealGasControlPanel.Measurement_Tools_on"), IdealGasResources.getString("IdealGasControlPanel.Measurement_Tools_off")){

            public void onAction() {
                ToolPanel.this.toolsPanel.setVisible(true);
                idealGasModule.getControlPanel().revalidate();
            }

            public void offAction() {
                ToolPanel.this.toolsPanel.setVisible(false);
                idealGasModule.getControlPanel().revalidate();
            }
        };
        this.topLevelGbc.fill = 0;
        this.topLevelGbc.anchor = 10;
        this.topLevelGbc.insets = this.buttonInsets;
        this.add((Component)this.button, this.topLevelGbc);
        this.toolsPanelInternalGbc.insets = this.panelInsets;
        this.toolsPanel.add((Component)new MeasurementToolsControls.PressureSliceControl(idealGasModule), this.toolsPanelInternalGbc);
        this.toolsPanel.add((Component)new MeasurementToolsControls.RulerControl(idealGasModule), this.toolsPanelInternalGbc);
        this.toolsPanel.add((Component)new MeasurementToolsControls.SpeciesMonitorControl(idealGasModule), this.toolsPanelInternalGbc);
        this.toolsPanel.add((Component)new MeasurementToolsControls.StopwatchControl(idealGasModule), this.toolsPanelInternalGbc);
        this.toolsPanel.add((Component)new MeasurementToolsControls.HistogramControlPanel(idealGasModule), this.toolsPanelInternalGbc);
        this.toolsPanel.add((Component)new MeasurementToolsControls.CmLinesControl(idealGasModule), this.toolsPanelInternalGbc);
        this.toolsPanel.setBorder(BorderFactory.createEtchedBorder());
        this.toolsPanel.setVisible(false);
        this.topLevelGbc.insets = this.panelInsets;
        ++this.topLevelGbc.gridy;
        this.topLevelGbc.fill = 2;
        this.add((Component)this.toolsPanel, this.topLevelGbc);
        ToggleButton toggleButton = new ToggleButton(IdealGasResources.getString("IdealGasControlPanel.MoreOptions"), IdealGasResources.getString("IdealGasControlPanel.FewerOptions")){

            public void onAction() {
                ToolPanel.this.advToolPanel.setVisible(true);
                idealGasModule.getControlPanel().revalidate();
            }

            public void offAction() {
                ToolPanel.this.advToolPanel.setVisible(false);
                idealGasModule.getControlPanel().revalidate();
            }
        };
        this.topLevelGbc.fill = 0;
        this.topLevelGbc.anchor = 10;
        this.topLevelGbc.insets = this.buttonInsets;
        ++this.topLevelGbc.gridy;
        this.add((Component)toggleButton, this.topLevelGbc);
        this.advToolPanel = new JPanel(new GridBagLayout());
        this.advToolPanel.add((Component)new MeasurementToolsControls.ParticleInteractionControl(idealGasModule.getIdealGasModel()), this.advToolsPanelInternalGbc);
        Pump[] pumpArray = new Pump[]{idealGasModule.getPump()};
        this.advToolPanel.add((Component)new InputTemperatureControlPanel(idealGasModule, pumpArray), this.advToolsPanelInternalGbc);
        this.advToolPanel.setBorder(BorderFactory.createEtchedBorder());
        this.advToolPanel.setVisible(false);
        this.topLevelGbc.insets = this.panelInsets;
        this.topLevelGbc.anchor = 18;
        this.topLevelGbc.fill = 2;
        ++this.topLevelGbc.gridy;
        this.add((Component)this.advToolPanel, this.topLevelGbc);
    }
}

