/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.controller;

import edu.colorado.phet.common.phetgraphics.view.phetcomponents.PhetJComponent;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.GraphicLayerSet;
import edu.colorado.phet.common.phetgraphics.view.phetgraphics.PhetGraphic;
import edu.colorado.phet.idealgas.IdealGasResources;
import edu.colorado.phet.idealgas.controller.IdealGasModule;
import edu.colorado.phet.idealgas.model.IdealGasModel;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StoveControlPanel
extends GraphicLayerSet {
    public StoveControlPanel(final IdealGasModule idealGasModule) {
        JPanel jPanel = new JPanel();
        int n = 40;
        final JSlider jSlider = new JSlider(1, -n, n, 0);
        jSlider.setMajorTickSpacing(n);
        jSlider.setMinorTickSpacing(10);
        jSlider.setSnapToTicks(true);
        Hashtable<Integer, JLabel> hashtable = new Hashtable<Integer, JLabel>();
        hashtable.put(new Integer(-40), new JLabel(IdealGasResources.getString("Common.Remove")));
        hashtable.put(new Integer(0), new JLabel(IdealGasResources.getString("Common.0")));
        hashtable.put(new Integer(40), new JLabel(IdealGasResources.getString("Common.Add")));
        jSlider.setLabelTable(hashtable);
        jSlider.setPaintTicks(true);
        jSlider.setSnapToTicks(true);
        jSlider.setPaintLabels(true);
        jSlider.setPreferredSize(new Dimension(100, 60));
        jSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                idealGasModule.setStove(jSlider.getValue());
            }
        });
        jSlider.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent mouseEvent) {
                jSlider.setValue(0);
            }
        });
        TitledBorder titledBorder = new TitledBorder(new EtchedBorder(0, new Color(40, 20, 255), Color.black), IdealGasResources.getString("IdealGasControlPanel.Heat_Control"));
        jPanel.setBorder(titledBorder);
        jPanel.setPreferredSize(new Dimension(115, 85));
        Color color = new Color(240, 230, 255);
        jPanel.setBackground(color);
        PhetGraphic phetGraphic = PhetJComponent.newInstance(idealGasModule.getApparatusPanel(), jPanel);
        this.addGraphic(phetGraphic);
        jSlider.setBackground(color);
        PhetGraphic phetGraphic2 = PhetJComponent.newInstance(idealGasModule.getApparatusPanel(), jSlider);
        phetGraphic2.setCursorHand();
        this.addGraphic(phetGraphic2);
        phetGraphic2.setLocation(10, 20);
        final IdealGasModel idealGasModel = idealGasModule.getIdealGasModel();
        idealGasModel.addChangeListener(new IdealGasModel.ChangeListener(){

            public void stateChanged(IdealGasModel.ChangeEvent changeEvent) {
                if (idealGasModel.getConstantProperty() == 3) {
                    jSlider.setEnabled(false);
                } else {
                    jSlider.setEnabled(true);
                }
            }
        });
    }
}

