/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.controller;

import edu.colorado.phet.common.phetcommon.application.PhetApplication;
import edu.colorado.phet.common.phetcommon.view.PhetFrame;
import edu.colorado.phet.idealgas.IdealGasResources;
import edu.colorado.phet.idealgas.controller.IdealGasModule;
import edu.colorado.phet.idealgas.model.IdealGasModel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JCheckBox;
import javax.swing.JDialog;

public class MeasurementToolsControls {

    public static class CmLinesControl
    extends JCheckBox {
        CmLinesControl(final IdealGasModule idealGasModule) {
            super(IdealGasResources.getString("IdealGasControlPanel.Show_CM_lines"));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    idealGasModule.setCmLinesOn(CmLinesControl.this.isSelected());
                }
            });
        }
    }

    public static class HistogramControlPanel
    extends JCheckBox {
        HistogramControlPanel(final IdealGasModule idealGasModule) {
            super(IdealGasResources.getString("MeasurementControlPanel.Display_energy_histograms"));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    WindowAdapter windowAdapter = new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            HistogramControlPanel.this.setSelected(false);
                        }
                    };
                    JDialog jDialog = idealGasModule.setHistogramDlgEnabled(HistogramControlPanel.this.isSelected());
                    if (jDialog != null) {
                        jDialog.addWindowListener(windowAdapter);
                    }
                }
            });
        }
    }

    public static class ParticleInteractionControl
    extends JCheckBox {
        ParticleInteractionControl(final IdealGasModel idealGasModel) {
            super(IdealGasResources.getString("MeasurementControlPanel.Molecules-interact"), true);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    idealGasModel.enableParticleParticleInteractions(ParticleInteractionControl.this.isSelected());
                }
            });
        }
    }

    public static class PressureSliceControl
    extends JCheckBox {
        PressureSliceControl(final IdealGasModule idealGasModule) {
            super(IdealGasResources.getString("MeasurementControlPanel.Measure_pressure_in_layer"));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    idealGasModule.setPressureSliceEnabled(PressureSliceControl.this.isSelected());
                }
            });
        }
    }

    public static class RulerControl
    extends JCheckBox {
        RulerControl(final IdealGasModule idealGasModule) {
            super(IdealGasResources.getString("MeasurementControlPanel.Display_ruler"));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    idealGasModule.setRulerEnabed(RulerControl.this.isSelected());
                }
            });
        }
    }

    public static class SpeciesMonitorControl
    extends JCheckBox {
        SpeciesMonitorControl(final IdealGasModule idealGasModule) {
            super(IdealGasResources.getString("MeasurementControlPanel.Show_species_information"));
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    WindowAdapter windowAdapter = new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            SpeciesMonitorControl.this.setSelected(false);
                        }
                    };
                    JDialog jDialog = idealGasModule.setSpeciesMonitorDlgEnabled(SpeciesMonitorControl.this.isSelected());
                    jDialog.addWindowListener(windowAdapter);
                }
            });
        }
    }

    public static class StopwatchControl
    extends JCheckBox {
        StopwatchControl(final IdealGasModule idealGasModule) {
            super(IdealGasResources.getString("MeasurementControlPanel.Stopwatch"), false);
            this.addActionListener(new ActionListener(){
                PhetFrame frame = PhetApplication.getInstance().getPhetFrame();

                public void actionPerformed(ActionEvent actionEvent) {
                    idealGasModule.setStopwatchEnabled(StopwatchControl.this.isSelected());
                }
            });
        }
    }
}

