/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.controller;

import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.idealgas.IdealGasResources;
import edu.colorado.phet.idealgas.collision.SphereHollowSphereExpert;
import edu.colorado.phet.idealgas.controller.GasSource;
import edu.colorado.phet.idealgas.controller.IdealGasModule;
import edu.colorado.phet.idealgas.controller.command.PumpMoleculeCmd;
import edu.colorado.phet.idealgas.model.Balloon;
import edu.colorado.phet.idealgas.model.BoxMustContainParticle;
import edu.colorado.phet.idealgas.model.GasMolecule;
import edu.colorado.phet.idealgas.model.HeavySpecies;
import edu.colorado.phet.idealgas.model.HollowSphere;
import edu.colorado.phet.idealgas.model.IdealGasClock;
import edu.colorado.phet.idealgas.model.LightSpecies;
import edu.colorado.phet.idealgas.model.Pump;
import edu.colorado.phet.idealgas.view.HollowSphereGraphic;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Random;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class HeliumBalloonModule
extends IdealGasModule
implements GasSource,
IdealGasModule.ResetListener {
    private static double MASS = 500.0;
    private HollowSphere balloon;
    private Class gasSpecies = LightSpecies.class;
    private int defaultGravity = 20;

    public HeliumBalloonModule(IdealGasClock idealGasClock) {
        super(idealGasClock, IdealGasResources.getString("ModuleTitle.HeliumBalloon"));
        this.addResetListener(this);
        this.getIdealGasModel().addCollisionExpert(new SphereHollowSphereExpert());
        this.balloon = new Balloon(new Point2D.Double(300.0, 350.0), new MutableVector2D(0.0, 0.0), new MutableVector2D(0.0, 0.0), MASS, 10.0, this.getIdealGasModel().getBox());
        this.getBox().setMinimumWidth(this.balloon.getRadius() * 3.0);
        this.getIdealGasModel().addModelElement(this.balloon);
        this.getIdealGasModel().getBox().addContainedBody(this.balloon);
        HollowSphereGraphic hollowSphereGraphic = new HollowSphereGraphic(this.getApparatusPanel(), this.balloon);
        this.addGraphic(hollowSphereGraphic, 10.0);
        BoxMustContainParticle boxMustContainParticle = new BoxMustContainParticle(this.getIdealGasModel().getBox(), this.balloon, this.getIdealGasModel());
        this.balloon.addConstraint(boxMustContainParticle);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder(IdealGasResources.getString("HeliumBalloonControlPanel.controlsTitle")));
        GridBagConstraints gridBagConstraints = null;
        Insets insets = new Insets(0, 0, 0, 0);
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 0, insets, 0, 0);
        jPanel.add((Component)new HeliumFactoryPanel(), gridBagConstraints);
        this.getIdealGasControlPanel().addParticleControl(jPanel);
        this.setGravity(this.defaultGravity);
    }

    protected Pump.PumpingEnergyStrategy getPumpingEnergyStrategy() {
        return new Pump.FixedEnergyStrategy();
    }

    public void setCurrentGasSpecies(Class clazz) {
        this.gasSpecies = LightSpecies.class;
    }

    public Class getCurrentGasSpecies() {
        return this.gasSpecies;
    }

    public void removeGasMolecule(Class clazz) {
        this.removeGasMolecule(clazz, false);
    }

    private void removeGasMolecule(Class clazz, boolean bl) {
        List list = this.getIdealGasModel().getBodies();
        Object var4_4 = null;
        while (var4_4 == null) {
            int n;
            boolean bl2 = new Random().nextBoolean();
            if (bl2) {
                for (n = 0; !(n >= list.size() || clazz.isInstance(var4_4 = list.get(n)) && this.balloon.containsBody(var4_4) == bl); ++n) {
                }
                continue;
            }
            for (n = list.size() - 1; !(n < 0 || clazz.isInstance(var4_4 = list.get(n)) && this.balloon.containsBody(var4_4) == bl); --n) {
            }
        }
        if (var4_4 instanceof GasMolecule) {
            GasMolecule gasMolecule = var4_4;
            this.getIdealGasModel().removeModelElement(gasMolecule);
            if (bl) {
                this.balloon.removeContainedBody(gasMolecule);
            }
        }
    }

    public int getHeavySpeciesCnt() {
        return super.getHeavySpeciesCnt() - this.balloon.getHeavySpeciesCnt();
    }

    public int getLightSpeciesCnt() {
        return super.getLightSpeciesCnt() - this.balloon.getLightSpeciesCnt();
    }

    public void resetOccurred(IdealGasModule.ResetEvent resetEvent) {
        this.balloon.setRadius(10.0);
    }

    class HeliumFactoryPanel
    extends JPanel
    implements IdealGasModule.ResetListener {
        private int currNumMolecules;
        private JSpinner particleSpinner;

        HeliumFactoryPanel() {
            super(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0);
            JLabel jLabel = new JLabel(IdealGasResources.getString("MeasurementControlPanel.Number_of_particles"));
            this.add((Component)jLabel, gridBagConstraints);
            Integer n = new Integer(0);
            Integer n2 = new Integer(0);
            Integer n3 = new Integer(1000);
            Integer n4 = new Integer(1);
            SpinnerNumberModel spinnerNumberModel = new SpinnerNumberModel(n, n2, n3, n4);
            this.particleSpinner = new JSpinner(spinnerNumberModel);
            this.particleSpinner.setPreferredSize(new Dimension(50, 20));
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 13;
            this.add((Component)this.particleSpinner, gridBagConstraints);
            this.particleSpinner.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    HeliumFactoryPanel.this.setNumParticles((Integer)HeliumFactoryPanel.this.particleSpinner.getValue());
                }
            });
            HeliumBalloonModule.this.addResetListener(this);
        }

        protected void setNumParticles(int n) {
            int n2 = n - this.currNumMolecules;
            if (n2 > 0) {
                for (int i = 0; i < n2; ++i) {
                    Class clazz = HeliumBalloonModule.this.getCurrentGasSpecies();
                    Point2D point2D = HeliumBalloonModule.this.balloon.getNewMoleculeLocation();
                    MutableVector2D mutableVector2D = HeliumBalloonModule.this.balloon.getNewMoleculeVelocity(clazz, HeliumBalloonModule.this.getIdealGasModel());
                    GasMolecule gasMolecule = null;
                    if (clazz == HeavySpecies.class) {
                        gasMolecule = new HeavySpecies(point2D, mutableVector2D, new MutableVector2D());
                    }
                    if (clazz == LightSpecies.class) {
                        gasMolecule = new LightSpecies(point2D, mutableVector2D, new MutableVector2D());
                    }
                    PumpMoleculeCmd pumpMoleculeCmd = new PumpMoleculeCmd(HeliumBalloonModule.this.getIdealGasModel(), gasMolecule, HeliumBalloonModule.this);
                    pumpMoleculeCmd.doIt();
                    HeliumBalloonModule.this.balloon.addContainedBody(gasMolecule);
                }
            } else if (n2 < 0) {
                for (int i = 0; i < -n2; ++i) {
                    HeliumBalloonModule.this.removeGasMolecule(LightSpecies.class, true);
                }
            }
            this.currNumMolecules += n2;
        }

        public void resetOccurred(IdealGasModule.ResetEvent resetEvent) {
            this.currNumMolecules = 0;
            this.particleSpinner.setEnabled(false);
            this.particleSpinner.setValue(new Integer(0));
            this.particleSpinner.setEnabled(true);
        }
    }
}

