/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.collision;

import edu.colorado.phet.idealgas.collision.Wall;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class WallDescriptor
implements Wall.ChangeListener {
    Rectangle2D contactBounds;
    Line2D AB;
    Line2D BC;
    Line2D CD;
    Line2D AD;
    private double contactRadius;

    WallDescriptor(Wall wall, double d) {
        this.contactRadius = d;
        this.computeDescriptor(wall);
        wall.addChangeListener(this);
    }

    private void computeDescriptor(Wall wall) {
        this.contactBounds = new Rectangle2D.Double(wall.getBounds().getMinX() - this.contactRadius, wall.getBounds().getMinY() - this.contactRadius, wall.getBounds().getWidth() + 2.0 * this.contactRadius, wall.getBounds().getHeight() + 2.0 * this.contactRadius);
        Point2D.Double double_ = new Point2D.Double(this.contactBounds.getMinX(), this.contactBounds.getMinY());
        Point2D.Double double_2 = new Point2D.Double(this.contactBounds.getMaxX(), this.contactBounds.getMinY());
        Point2D.Double double_3 = new Point2D.Double(this.contactBounds.getMaxX(), this.contactBounds.getMaxY());
        Point2D.Double double_4 = new Point2D.Double(this.contactBounds.getMinX(), this.contactBounds.getMaxY());
        this.AB = new Line2D.Double(double_, double_2);
        this.BC = new Line2D.Double(double_2, double_3);
        this.CD = new Line2D.Double(double_3, double_4);
        this.AD = new Line2D.Double(double_, double_4);
    }

    public void wallChanged(Wall.ChangeEvent changeEvent) {
        this.computeDescriptor(changeEvent.getWall());
    }
}

