/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.collision;

import edu.colorado.phet.idealgas.collision.CollidableBody;
import edu.colorado.phet.idealgas.collision.CollisionExpert;
import edu.colorado.phet.idealgas.collision.ContactDetector;
import edu.colorado.phet.idealgas.collision.SphereWallCollision;
import edu.colorado.phet.idealgas.collision.SphericalBody;
import edu.colorado.phet.idealgas.collision.Wall;
import edu.colorado.phet.idealgas.collision.WallDescriptor;
import edu.colorado.phet.idealgas.model.IdealGasModel;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Map;

public class SphereWallExpert
implements CollisionExpert,
ContactDetector {
    private IdealGasModel model;
    private Map walls = new HashMap();

    public SphereWallExpert(IdealGasModel idealGasModel) {
        this.model = idealGasModel;
    }

    public boolean detectAndDoCollision(CollidableBody collidableBody, CollidableBody collidableBody2) {
        boolean bl = false;
        ContactDescriptor contactDescriptor = this.getContactType(collidableBody, collidableBody2);
        if (contactDescriptor != null) {
            new SphereWallCollision(contactDescriptor.sphere, contactDescriptor.wall, contactDescriptor.type, this.model).collide();
            bl = true;
        }
        return bl;
    }

    public boolean applies(CollidableBody collidableBody, CollidableBody collidableBody2) {
        return collidableBody instanceof SphericalBody && collidableBody2 instanceof Wall || collidableBody instanceof Wall && collidableBody2 instanceof SphericalBody;
    }

    public boolean areInContact(CollidableBody collidableBody, CollidableBody collidableBody2) {
        return this.getContactType((CollidableBody)collidableBody, (CollidableBody)collidableBody2).type != 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ContactDescriptor getContactType(CollidableBody collidableBody, CollidableBody collidableBody2) {
        SphericalBody sphericalBody;
        int n = 0;
        Wall wall = null;
        if (collidableBody instanceof Wall) {
            wall = (Wall)collidableBody;
            if (!(collidableBody2 instanceof SphericalBody)) return null;
            sphericalBody = (SphericalBody)collidableBody2;
        } else {
            if (!(collidableBody2 instanceof Wall)) return null;
            wall = (Wall)collidableBody2;
            if (!(collidableBody instanceof SphericalBody)) return null;
            sphericalBody = (SphericalBody)collidableBody;
        }
        n = this.check3(sphericalBody, wall);
        ContactDescriptor contactDescriptor = null;
        if (n == 0) return contactDescriptor;
        return new ContactDescriptor(wall, sphericalBody, n);
    }

    private int check3(SphericalBody sphericalBody, Wall wall) {
        Point2D point2D;
        Point2D point2D2;
        Line2D.Double double_;
        int n = 0;
        WallDescriptor wallDescriptor = (WallDescriptor)this.walls.get(wall);
        if (wallDescriptor == null) {
            wallDescriptor = new WallDescriptor(wall, sphericalBody.getRadius());
            this.walls.put(wall, wallDescriptor);
        }
        if ((double_ = new Line2D.Double(point2D2 = sphericalBody.getPosition(), point2D = sphericalBody.getPositionPrev())).intersectsLine(wallDescriptor.AB) && sphericalBody.getVelocity().getY() > 0.0) {
            n = 3;
        }
        if (double_.intersectsLine(wallDescriptor.BC) && sphericalBody.getVelocity().getX() < 0.0) {
            n = 2;
        }
        if (double_.intersectsLine(wallDescriptor.CD) && sphericalBody.getVelocity().getY() < 0.0) {
            n = 4;
        }
        if (double_.intersectsLine(wallDescriptor.AD) && sphericalBody.getVelocity().getX() > 0.0) {
            n = 1;
        }
        return n;
    }

    private class ContactDescriptor {
        Wall wall;
        SphericalBody sphere;
        int type;

        public ContactDescriptor(Wall wall, SphericalBody sphericalBody, int n) {
            this.wall = wall;
            this.sphere = sphericalBody;
            this.type = n;
        }
    }
}

