/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.collision;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.idealgas.collision.CollidableBody;
import edu.colorado.phet.idealgas.collision.Collision;
import edu.colorado.phet.idealgas.collision.SphericalBody;
import java.awt.geom.Point2D;

public class SphereSphereCollision
implements Collision {
    private SphericalBody sphereA;
    private SphericalBody sphereB;
    private MutableVector2D loa = new MutableVector2D();
    static MutableVector2D vRel = new MutableVector2D();
    static MutableVector2D n = new MutableVector2D();

    public SphereSphereCollision(SphericalBody sphericalBody, SphericalBody sphericalBody2) {
        this.sphereA = sphericalBody;
        this.sphereB = sphericalBody2;
    }

    protected MutableVector2D getLoa(CollidableBody collidableBody, CollidableBody collidableBody2) {
        Point2D point2D = collidableBody.getPosition();
        Point2D point2D2 = collidableBody2.getPosition();
        this.loa.setX(point2D.getX() - point2D2.getX());
        this.loa.setY(point2D.getY() - point2D2.getY());
        return this.loa;
    }

    public void collide() {
        double d = Math.sqrt(this.sphereA.getPosition().distanceSq(this.sphereB.getPosition()));
        double d2 = this.sphereA.getRadius() / d;
        Point2D.Double double_ = new Point2D.Double(this.sphereA.getPosition().getX() + (this.sphereB.getPosition().getX() - this.sphereA.getPosition().getX()) * d2, this.sphereA.getPosition().getY() + (this.sphereB.getPosition().getY() - this.sphereA.getPosition().getY()) * d2);
        this.doCollision(this.getLoa(this.sphereA, this.sphereB), double_);
    }

    public void doCollision(MutableVector2D mutableVector2D, Point2D point2D) {
        n.setComponents(mutableVector2D.getX(), mutableVector2D.getY());
        n.normalize();
        vRel.setComponents(this.sphereA.getVelocity().getX(), this.sphereA.getVelocity().getY());
        vRel.subtract(this.sphereB.getVelocity());
        MutableVector2D mutableVector2D2 = new MutableVector2D(mutableVector2D.getY(), -mutableVector2D.getX());
        Point2D point2D2 = this.sphereB.getPositionPrev();
        double d = point2D2.distance(point2D);
        double d2 = this.sphereB.getRadius() / d;
        double d3 = this.sphereB.getPositionPrev().distance(this.sphereA.getPositionPrev()) < this.sphereA.getRadius() ? -this.sphereB.getRadius() : this.sphereB.getRadius();
        double d4 = n.getX() * d3;
        double d5 = n.getY() * d3;
        Point2D.Double double_ = new Point2D.Double(point2D.getX() - d4, point2D.getY() - d5);
        Point2D point2D3 = MathUtil.reflectPointAcrossLine(this.sphereB.getPosition(), double_, Math.atan2(mutableVector2D2.getY(), mutableVector2D2.getX()));
        this.sphereB.setPosition(point2D3);
        Point2D point2D4 = this.sphereA.getPositionPrev();
        double d6 = point2D4.distance(point2D);
        double d7 = this.sphereA.getRadius() / d6;
        Point2D.Double double_2 = new Point2D.Double(point2D.getX() - (point2D.getX() - point2D4.getX()) * d7, point2D.getY() - (point2D.getY() - point2D4.getY()) * d7);
        double d8 = -this.sphereA.getRadius();
        double d9 = n.getX() * d8;
        double d10 = n.getY() * d8;
        Point2D point2D5 = MathUtil.reflectPointAcrossLine(this.sphereA.getPosition(), double_2, Math.atan2(mutableVector2D2.getY(), mutableVector2D2.getX()));
        this.sphereA.setPosition(point2D5);
        double d11 = vRel.dot(n);
        float f = 1.0f;
        double d12 = -d11 * (double)(1.0f + f);
        double d13 = 1.0 / this.sphereA.getMass() + 1.0 / this.sphereB.getMass();
        double d14 = d12 / d13;
        MutableVector2D mutableVector2D3 = new MutableVector2D(n.getX(), n.getY()).scale(d14 / this.sphereA.getMass());
        this.sphereA.getVelocity().add(mutableVector2D3);
        MutableVector2D mutableVector2D4 = new MutableVector2D(n.getX(), n.getY()).scale(-d14 / this.sphereB.getMass());
        this.sphereB.getVelocity().add(mutableVector2D4);
    }
}

