/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.collision;

import edu.colorado.phet.common.phetcommon.model.Particle;
import edu.colorado.phet.idealgas.collision.CollidableBody;
import edu.colorado.phet.idealgas.collision.CollisionExpert;
import edu.colorado.phet.idealgas.collision.ContactDetector;
import edu.colorado.phet.idealgas.collision.SphereHollowSphereContactDetector;
import edu.colorado.phet.idealgas.collision.SphereSphereCollision;
import edu.colorado.phet.idealgas.collision.SphericalBody;
import edu.colorado.phet.idealgas.model.HollowSphere;

public class SphereHollowSphereExpert
implements CollisionExpert {
    private ContactDetector detector = new SphereHollowSphereContactDetector();

    public boolean detectAndDoCollision(CollidableBody collidableBody, CollidableBody collidableBody2) {
        Object object;
        boolean bl = false;
        if (this.detector.applies(collidableBody, collidableBody2) && this.detector.areInContact(collidableBody, collidableBody2)) {
            object = new SphereSphereCollision((HollowSphere)collidableBody, (SphericalBody)collidableBody2);
            object.collide();
            bl = true;
        }
        if (this.detector.applies(collidableBody, collidableBody2)) {
            object = null;
            SphericalBody sphericalBody = null;
            if (collidableBody instanceof HollowSphere) {
                object = (HollowSphere)collidableBody;
                sphericalBody = (SphericalBody)collidableBody2;
            } else {
                object = (HollowSphere)collidableBody2;
                sphericalBody = (SphericalBody)collidableBody;
            }
            double d = ((Particle)object).getPosition().distance(sphericalBody.getPosition());
            if (((HollowSphere)object).containsBody(sphericalBody)) {
                if (d + sphericalBody.getRadius() > ((SphericalBody)object).getRadius()) {
                    SphereSphereCollision sphereSphereCollision = new SphereSphereCollision((HollowSphere)collidableBody, (SphericalBody)collidableBody2);
                    sphereSphereCollision.collide();
                    bl = true;
                }
            } else if (d - sphericalBody.getRadius() < ((SphericalBody)object).getRadius()) {
                SphereSphereCollision sphereSphereCollision = new SphereSphereCollision((HollowSphere)collidableBody, (SphericalBody)collidableBody2);
                sphereSphereCollision.collide();
                bl = true;
            }
        }
        if (bl) {
            object = collidableBody instanceof HollowSphere ? (HollowSphere)collidableBody : (HollowSphere)collidableBody2;
            ((HollowSphere)object).collideWithParticle(collidableBody2);
        }
        return bl;
    }
}

