/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.collision;

import edu.colorado.phet.common.phetcommon.math.MathUtil;
import edu.colorado.phet.idealgas.IdealGasConfig;
import edu.colorado.phet.idealgas.collision.Collision;
import edu.colorado.phet.idealgas.collision.SphericalBody;
import edu.colorado.phet.idealgas.model.Box2D;
import edu.colorado.phet.idealgas.model.IdealGasModel;

public class SphereBoxCollision
implements Collision {
    private SphericalBody sphere;
    private Box2D box;
    private IdealGasModel model;

    public SphereBoxCollision(SphericalBody sphericalBody, Box2D box2D, IdealGasModel idealGasModel) {
        this.sphere = sphericalBody;
        this.box = box2D;
        this.model = idealGasModel;
    }

    public void collide() {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        double d6 = this.sphere.getPosition().getX();
        double d7 = this.sphere.getPosition().getY();
        double d8 = this.sphere.getPositionPrev().getX();
        double d9 = this.sphere.getPositionPrev().getY();
        double d10 = this.sphere.getRadius();
        if (this.box.isInOpening(this.sphere)) {
            return;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        bl = d6 - d10 <= this.box.getMinX();
        bl2 = d6 + d10 >= this.box.getMaxX();
        bl3 = d7 - d10 <= this.box.getMinY();
        boolean bl5 = bl4 = d7 + d10 >= this.box.getMaxY();
        if (bl && !bl2) {
            this.sphere.setVelocity(-this.sphere.getVelocity().getX(), this.sphere.getVelocity().getY());
            d5 = this.box.getMinX();
            d4 = d5 - (d6 - d10);
            d3 = d6 + d4 * 2.0;
            this.sphere.setPosition(d3, this.sphere.getPosition().getY());
            if (this.model.isWorkDoneByMovingWall()) {
                d2 = this.sphere.getVelocity().getX();
                d = d2 + this.box.getLeftWallVx();
                double d11 = this.sphere.getKineticEnergy();
                this.sphere.setVelocity(d, this.sphere.getVelocity().getY());
                double d12 = this.sphere.getKineticEnergy();
                this.model.addKineticEnergyToSystem(d12 - d11);
            }
        }
        if (bl2 && !bl) {
            this.sphere.setVelocity(-this.sphere.getVelocity().getX(), this.sphere.getVelocity().getY());
            d5 = this.box.getMaxX();
            d4 = d6 + d10 - d5;
            d3 = d6 - d4 * 2.0;
            this.sphere.setPosition(d3, this.sphere.getPosition().getY());
        }
        if (bl3 && !bl4) {
            this.sphere.setVelocity(this.sphere.getVelocity().getX(), -this.sphere.getVelocity().getY());
            d5 = this.box.getMinY();
            d4 = d5 - (d7 - d10);
            d3 = d7 + d4 * 2.0;
            this.sphere.setPosition(this.sphere.getPosition().getX(), d3);
            this.adjustDyForGravity(d4 * 2.0);
        }
        if (bl4 && !bl3) {
            this.sphere.setVelocity(this.sphere.getVelocity().getX(), -this.sphere.getVelocity().getY());
            d5 = this.box.getMaxY();
            d4 = d7 + d10 - d5;
            d3 = d7 - d4 * 2.0;
            this.sphere.setPosition(this.sphere.getPosition().getX(), d3);
            this.adjustDyForGravity(d4 * 2.0);
            if (IdealGasConfig.HEAT_ONLY_FROM_FLOOR) {
                d2 = this.sphere.getKineticEnergy();
                this.sphere.setVelocity(this.sphere.getVelocity().scale(1.0 + this.model.getHeatSource() / 10000.0));
                d = this.sphere.getKineticEnergy() - d2;
                this.model.addKineticEnergyToSystem(d);
            }
        }
    }

    private void adjustDyForGravity(double d) {
        double d2 = this.sphere.getMass();
        double d3 = this.model.getGravity().getAmt();
        double d4 = this.sphere.getMass() * this.sphere.getVelocity().getY() * this.sphere.getVelocity().getY() / 2.0;
        double d5 = d * d3 * this.sphere.getMass();
        double d6 = 0.0;
        if (d4 >= d5) {
            d6 = Math.sqrt(2.0 / d2 * (d4 - d5)) * (double)MathUtil.getSign(this.sphere.getVelocity().getY());
            this.sphere.setVelocity(this.sphere.getVelocity().getX(), d6);
        }
    }
}

