/*
 * Decompiled with CFR 0.152.
 */
package edu.colorado.phet.idealgas.collision;

import edu.colorado.phet.common.mechanics.Body;
import edu.colorado.phet.common.phetcommon.math.vector.MutableVector2D;
import edu.colorado.phet.idealgas.model.Constraint;
import java.awt.geom.Point2D;
import java.util.ArrayList;

public abstract class CollidableBody
extends Body {
    private boolean collidable = true;
    private MutableVector2D velocityPrev;
    private Point2D positionPrev;
    ArrayList containedBodies = new ArrayList();
    protected ArrayList constraints = new ArrayList();
    private Point2D positionBeforeTimeStep = new Point2D.Double();

    protected CollidableBody() {
    }

    protected CollidableBody(Point2D point2D, MutableVector2D mutableVector2D, MutableVector2D mutableVector2D2, double d, double d2) {
        super(point2D, mutableVector2D, mutableVector2D2, d, d2);
    }

    public void stepInTime(double d) {
        if (this.velocityPrev == null) {
            this.velocityPrev = new MutableVector2D();
        }
        this.velocityPrev.setComponents(this.getVelocity().getX(), this.getVelocity().getY());
        if (this.positionPrev == null) {
            this.positionPrev = new Point2D.Double(this.getPosition().getX(), this.getPosition().getY());
        }
        this.positionPrev.setLocation(this.getPosition());
        this.positionBeforeTimeStep.setLocation(this.getPosition());
        super.stepInTime(d);
    }

    public Point2D getPositionPrev() {
        return this.positionPrev;
    }

    public void addContainedBody(Body body) {
        this.containedBodies.add(body);
    }

    public void removeContainedBody(Body body) {
        this.containedBodies.remove(body);
    }

    public boolean containsBody(Body body) {
        return this.containedBodies.contains(body);
    }

    public void addConstraint(Constraint constraint) {
        this.constraints.add(constraint);
    }
}

