/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.base;

import java.util.ArrayList;
import java.util.List;
import org.jfree.base.Library;

public class BasicProjectInfo
extends Library {
    private String copyright;
    private List libraries = new ArrayList();
    private List optionalLibraries = new ArrayList();

    public BasicProjectInfo() {
    }

    public BasicProjectInfo(String name, String version, String licence, String info) {
        this();
        this.setName(name);
        this.setVersion(version);
        this.setLicenceName(licence);
        this.setInfo(info);
    }

    public String getCopyright() {
        return this.copyright;
    }

    public void setCopyright(String copyright) {
        this.copyright = copyright;
    }

    public void setInfo(String info) {
        super.setInfo(info);
    }

    public void setLicenceName(String licence) {
        super.setLicenceName(licence);
    }

    public void setName(String name) {
        super.setName(name);
    }

    public void setVersion(String version) {
        super.setVersion(version);
    }

    public Library[] getLibraries() {
        return this.libraries.toArray(new Library[this.libraries.size()]);
    }

    public void addLibrary(Library library) {
        if (library == null) {
            throw new NullPointerException();
        }
        this.libraries.add(library);
    }

    public void addOptionalLibrary(Library library) {
        if (library == null) {
            throw new NullPointerException("Library must be given.");
        }
        this.optionalLibraries.add(new OptionalLibraryHolder(library));
    }

    private static class OptionalLibraryHolder {
        private String libraryClass;
        private transient Library library;

        public OptionalLibraryHolder(Library library) {
            if (library == null) {
                throw new NullPointerException("Library must not be null.");
            }
            this.library = library;
            this.libraryClass = library.getClass().getName();
        }
    }
}

